/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSRuntimeExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaBytesMessage;
import com.github.marschall.jakartajmsadapter.JakartaConnectionMetaData;
import com.github.marschall.jakartajmsadapter.JakartaJMSConsumer;
import com.github.marschall.jakartajmsadapter.JakartaJMSProducer;
import com.github.marschall.jakartajmsadapter.JakartaMapMessage;
import com.github.marschall.jakartajmsadapter.JakartaMessage;
import com.github.marschall.jakartajmsadapter.JakartaObjectMessage;
import com.github.marschall.jakartajmsadapter.JakartaQueue;
import com.github.marschall.jakartajmsadapter.JakartaQueueBrowser;
import com.github.marschall.jakartajmsadapter.JakartaStreamMessage;
import com.github.marschall.jakartajmsadapter.JakartaTemporaryQueue;
import com.github.marschall.jakartajmsadapter.JakartaTemporaryTopic;
import com.github.marschall.jakartajmsadapter.JakartaTextMessage;
import com.github.marschall.jakartajmsadapter.JakartaTopic;
import com.github.marschall.jakartajmsadapter.JavaxExceptionListener;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSRuntimeException;
import javax.jms.Queue;
import javax.jms.Topic;

final class JakartaJMSContext
implements jakarta.jms.JMSContext {
    private final JMSContext javaxJMSContext;
    private ExceptionListener listener;

    JakartaJMSContext(JMSContext javaxJMSContext) {
        this.javaxJMSContext = javaxJMSContext;
    }

    public jakarta.jms.JMSContext createContext(int sessionMode) {
        try {
            return new JakartaJMSContext(this.javaxJMSContext.createContext(sessionMode));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSProducer createProducer() {
        try {
            return new JakartaJMSProducer(this.javaxJMSContext.createProducer());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public String getClientID() {
        try {
            return this.javaxJMSContext.getClientID();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void setClientID(String clientID) {
        try {
            this.javaxJMSContext.setClientID(clientID);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            return new JakartaConnectionMetaData(this.javaxJMSContext.getMetaData());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            this.javaxJMSContext.getExceptionListener();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        JavaxExceptionListener javaxListener = listener != null ? new JavaxExceptionListener(listener) : null;
        try {
            this.javaxJMSContext.setExceptionListener((javax.jms.ExceptionListener)javaxListener);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        this.listener = listener;
    }

    public void start() {
        try {
            this.javaxJMSContext.start();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void stop() {
        try {
            this.javaxJMSContext.stop();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void setAutoStart(boolean autoStart) {
        try {
            this.javaxJMSContext.setAutoStart(autoStart);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public boolean getAutoStart() {
        try {
            return this.javaxJMSContext.getAutoStart();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void close() {
        try {
            this.javaxJMSContext.close();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public BytesMessage createBytesMessage() {
        try {
            return new JakartaBytesMessage(this.javaxJMSContext.createBytesMessage());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public MapMessage createMapMessage() {
        try {
            return new JakartaMapMessage(this.javaxJMSContext.createMapMessage());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public Message createMessage() {
        try {
            return new JakartaMessage(this.javaxJMSContext.createMessage());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public ObjectMessage createObjectMessage() {
        try {
            return new JakartaObjectMessage(this.javaxJMSContext.createObjectMessage());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        try {
            return new JakartaObjectMessage(this.javaxJMSContext.createObjectMessage(object));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public StreamMessage createStreamMessage() {
        try {
            return new JakartaStreamMessage(this.javaxJMSContext.createStreamMessage());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public TextMessage createTextMessage() {
        try {
            return new JakartaTextMessage(this.javaxJMSContext.createTextMessage());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public TextMessage createTextMessage(String text) {
        try {
            return new JakartaTextMessage(this.javaxJMSContext.createTextMessage(text));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public boolean getTransacted() {
        try {
            return this.javaxJMSContext.getTransacted();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public int getSessionMode() {
        try {
            return this.javaxJMSContext.getSessionMode();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void commit() {
        try {
            this.javaxJMSContext.commit();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void rollback() {
        try {
            this.javaxJMSContext.rollback();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void recover() {
        try {
            this.javaxJMSContext.recover();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createConsumer(jakarta.jms.Destination destination) {
        Destination javaxDestination = Wrapper.unwrapUnchecked(destination, Destination.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createConsumer(javaxDestination));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createConsumer(jakarta.jms.Destination destination, String messageSelector) {
        Destination javaxDestination = Wrapper.unwrapUnchecked(destination, Destination.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createConsumer(javaxDestination, messageSelector));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createConsumer(jakarta.jms.Destination destination, String messageSelector, boolean noLocal) {
        Destination javaxDestination = Wrapper.unwrapUnchecked(destination, Destination.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createConsumer(javaxDestination, messageSelector, noLocal));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.Queue createQueue(String queueName) {
        try {
            return new JakartaQueue(this.javaxJMSContext.createQueue(queueName));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.Topic createTopic(String topicName) {
        try {
            return new JakartaTopic(this.javaxJMSContext.createTopic(topicName));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createDurableConsumer(jakarta.jms.Topic topic, String name) {
        Topic javaxTopic = Wrapper.unwrapUnchecked(topic, Topic.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createDurableConsumer(javaxTopic, name));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createDurableConsumer(jakarta.jms.Topic topic, String name, String messageSelector, boolean noLocal) {
        Topic javaxTopic = Wrapper.unwrapUnchecked(topic, Topic.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createDurableConsumer(javaxTopic, name, messageSelector, noLocal));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createSharedDurableConsumer(jakarta.jms.Topic topic, String name) {
        Topic javaxTopic = Wrapper.unwrapUnchecked(topic, Topic.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createSharedDurableConsumer(javaxTopic, name));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createSharedDurableConsumer(jakarta.jms.Topic topic, String name, String messageSelector) {
        Topic javaxTopic = Wrapper.unwrapUnchecked(topic, Topic.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createSharedDurableConsumer(javaxTopic, name, messageSelector));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createSharedConsumer(jakarta.jms.Topic topic, String sharedSubscriptionName) {
        Topic javaxTopic = Wrapper.unwrapUnchecked(topic, Topic.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createSharedConsumer(javaxTopic, sharedSubscriptionName));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSConsumer createSharedConsumer(jakarta.jms.Topic topic, String sharedSubscriptionName, String messageSelector) {
        Topic javaxTopic = Wrapper.unwrapUnchecked(topic, Topic.class);
        try {
            return new JakartaJMSConsumer(this.javaxJMSContext.createSharedConsumer(javaxTopic, sharedSubscriptionName, messageSelector));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public QueueBrowser createBrowser(jakarta.jms.Queue queue) {
        Queue javaxQueue = Wrapper.unwrapUnchecked(queue, Queue.class);
        try {
            return new JakartaQueueBrowser(this.javaxJMSContext.createBrowser(javaxQueue));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public QueueBrowser createBrowser(jakarta.jms.Queue queue, String messageSelector) {
        Queue javaxQueue = Wrapper.unwrapUnchecked(queue, Queue.class);
        try {
            return new JakartaQueueBrowser(this.javaxJMSContext.createBrowser(javaxQueue, messageSelector));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        try {
            return new JakartaTemporaryQueue(this.javaxJMSContext.createTemporaryQueue());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        try {
            return new JakartaTemporaryTopic(this.javaxJMSContext.createTemporaryTopic());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void unsubscribe(String name) {
        try {
            this.javaxJMSContext.unsubscribe(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void acknowledge() {
        try {
            this.javaxJMSContext.acknowledge();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }
}

