/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaBytesMessage;
import com.github.marschall.jakartajmsadapter.JakartaMapMessage;
import com.github.marschall.jakartajmsadapter.JakartaObjectMessage;
import com.github.marschall.jakartajmsadapter.JakartaStreamMessage;
import com.github.marschall.jakartajmsadapter.JakartaTextMessage;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.Message;
import java.util.Enumeration;
import java.util.Objects;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class JakartaMessage
implements Message,
Wrapper {
    private final javax.jms.Message javaxMessage;

    JakartaMessage(javax.jms.Message javaxMessage) {
        Objects.requireNonNull(javaxMessage);
        this.javaxMessage = javaxMessage;
    }

    public String getJMSMessageID() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSMessageID();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSMessageID(String id) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSMessageID(id);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public long getJMSTimestamp() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSTimestamp();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSTimestamp(long timestamp) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSTimestamp(timestamp);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public byte[] getJMSCorrelationIDAsBytes() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSCorrelationIDAsBytes();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSCorrelationIDAsBytes(correlationID);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSCorrelationID(String correlationID) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSCorrelationID(correlationID);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public String getJMSCorrelationID() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSCorrelationID();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.Destination getJMSReplyTo() throws jakarta.jms.JMSException {
        try {
            return Wrapper.fromJavaxDestination(this.javaxMessage.getJMSReplyTo());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSReplyTo(jakarta.jms.Destination replyTo) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSReplyTo(Wrapper.unwrapObject(replyTo, Destination.class));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.Destination getJMSDestination() throws jakarta.jms.JMSException {
        try {
            return Wrapper.fromJavaxDestination(this.javaxMessage.getJMSDestination());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSDestination(jakarta.jms.Destination destination) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSDestination(Wrapper.unwrapObject(destination, Destination.class));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public int getJMSDeliveryMode() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSDeliveryMode();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSDeliveryMode(int deliveryMode) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSDeliveryMode(deliveryMode);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public boolean getJMSRedelivered() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSRedelivered();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSRedelivered(boolean redelivered) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSRedelivered(redelivered);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public String getJMSType() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSType();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSType(String type) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSType(type);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public long getJMSExpiration() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSExpiration();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSExpiration(long expiration) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSExpiration(expiration);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public long getJMSDeliveryTime() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSDeliveryTime();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSDeliveryTime(long deliveryTime) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSDeliveryTime(deliveryTime);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public int getJMSPriority() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getJMSPriority();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setJMSPriority(int priority) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setJMSPriority(priority);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void clearProperties() throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.clearProperties();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public boolean propertyExists(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.propertyExists(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public boolean getBooleanProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getBooleanProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public byte getByteProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getByteProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public short getShortProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getShortProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public int getIntProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getIntProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public long getLongProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getLongProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public float getFloatProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getFloatProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public double getDoubleProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getDoubleProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public String getStringProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getStringProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Object getObjectProperty(String name) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getObjectProperty(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Enumeration getPropertyNames() throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.getPropertyNames();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setBooleanProperty(String name, boolean value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setBooleanProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setByteProperty(String name, byte value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setByteProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setShortProperty(String name, short value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setShortProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setIntProperty(String name, int value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setIntProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setLongProperty(String name, long value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setLongProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setFloatProperty(String name, float value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setFloatProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setDoubleProperty(String name, double value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setDoubleProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setStringProperty(String name, String value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setStringProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setObjectProperty(String name, Object value) throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.setObjectProperty(name, value);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void acknowledge() throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.acknowledge();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void clearBody() throws jakarta.jms.JMSException {
        try {
            this.javaxMessage.clearBody();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public <T> T getBody(Class<T> c) throws jakarta.jms.JMSException {
        try {
            return (T)this.javaxMessage.getBody(c);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public boolean isBodyAssignableTo(Class c) throws jakarta.jms.JMSException {
        try {
            return this.javaxMessage.isBodyAssignableTo(c);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    @Override
    public Object getJavaxObject() {
        return this.javaxMessage;
    }

    static Message fromJavax(javax.jms.Message message) {
        if (message == null) {
            return null;
        }
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            return new JakartaBytesMessage(bytesMessage);
        }
        if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            return new JakartaMapMessage(mapMessage);
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            return new JakartaObjectMessage(objectMessage);
        }
        if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            return new JakartaStreamMessage(streamMessage);
        }
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            return new JakartaTextMessage(textMessage);
        }
        return new JakartaMessage(message);
    }
}

