/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaMessage;
import com.github.marschall.jakartajmsadapter.JavaxMessageListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import javax.jms.MessageConsumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class JakartaMessageConsumer
implements jakarta.jms.MessageConsumer {
    private final MessageConsumer javaxMessageConsumer;
    private MessageListener listener;

    JakartaMessageConsumer(MessageConsumer javaxMessageConsumer) {
        this.javaxMessageConsumer = javaxMessageConsumer;
    }

    public String getMessageSelector() throws JMSException {
        try {
            return this.javaxMessageConsumer.getMessageSelector();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        try {
            this.javaxMessageConsumer.getMessageListener();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        JavaxMessageListener javaxListener = listener != null ? new JavaxMessageListener(listener) : null;
        try {
            this.javaxMessageConsumer.setMessageListener((javax.jms.MessageListener)javaxListener);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
        this.listener = listener;
    }

    public Message receive() throws JMSException {
        try {
            return JakartaMessage.fromJavax(this.javaxMessageConsumer.receive());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Message receive(long timeout) throws JMSException {
        try {
            return JakartaMessage.fromJavax(this.javaxMessageConsumer.receive(timeout));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Message receiveNoWait() throws JMSException {
        try {
            return JakartaMessage.fromJavax(this.javaxMessageConsumer.receiveNoWait());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void close() throws JMSException {
        try {
            this.javaxMessageConsumer.close();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

