/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaMessage;
import com.github.marschall.jakartajmsadapter.JakartaQueue;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import java.util.Enumeration;
import javax.jms.Message;
import javax.jms.QueueBrowser;

final class JakartaQueueBrowser
implements jakarta.jms.QueueBrowser {
    private final QueueBrowser javaxQueueBrowser;

    JakartaQueueBrowser(QueueBrowser queueBrowser) {
        this.javaxQueueBrowser = queueBrowser;
    }

    public Queue getQueue() throws JMSException {
        try {
            return new JakartaQueue(this.javaxQueueBrowser.getQueue());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public String getMessageSelector() throws JMSException {
        try {
            return this.javaxQueueBrowser.getMessageSelector();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        try {
            return new JakartaEnumeration(this.javaxQueueBrowser.getEnumeration());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void close() throws JMSException {
        try {
            this.javaxQueueBrowser.close();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    static final class JakartaEnumeration
    implements Enumeration {
        private final Enumeration javaxEnumeration;

        JakartaEnumeration(Enumeration javaxEnumeration) {
            this.javaxEnumeration = javaxEnumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.javaxEnumeration.hasMoreElements();
        }

        public Object nextElement() {
            Object nextElement = this.javaxEnumeration.nextElement();
            if (nextElement instanceof Message) {
                Message message = (Message)nextElement;
                return JakartaMessage.fromJavax(message);
            }
            return nextElement;
        }
    }
}

