/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaMessageProducer;
import com.github.marschall.jakartajmsadapter.JakartaQueue;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import javax.jms.MessageProducer;
import javax.jms.QueueSender;

final class JakartaQueueSender
extends JakartaMessageProducer
implements jakarta.jms.QueueSender {
    private final QueueSender javaxQueueSender;

    JakartaQueueSender(QueueSender javaxQueueSender) {
        super((MessageProducer)javaxQueueSender);
        this.javaxQueueSender = javaxQueueSender;
    }

    public Queue getQueue() throws JMSException {
        try {
            return new JakartaQueue(this.javaxQueueSender.getQueue());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void send(Queue queue, Message message) throws JMSException {
        javax.jms.Queue javaxQueue = Wrapper.unwrapObject(queue, javax.jms.Queue.class);
        javax.jms.Message javaxMessage = Wrapper.unwrapObject(queue, javax.jms.Message.class);
        try {
            this.javaxQueueSender.send(javaxQueue, javaxMessage);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        javax.jms.Queue javaxQueue = Wrapper.unwrapObject(queue, javax.jms.Queue.class);
        javax.jms.Message javaxMessage = Wrapper.unwrapObject(queue, javax.jms.Message.class);
        try {
            this.javaxQueueSender.send(javaxQueue, javaxMessage, deliveryMode, priority, timeToLive);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

