/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaQueueReceiver;
import com.github.marschall.jakartajmsadapter.JakartaQueueSender;
import com.github.marschall.jakartajmsadapter.JakartaSession;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;

final class JakartaQueueSession
extends JakartaSession
implements jakarta.jms.QueueSession {
    private final QueueSession javaxQueueSession;

    JakartaQueueSession(QueueSession javaxQueueSession) {
        super((Session)javaxQueueSession);
        this.javaxQueueSession = javaxQueueSession;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        javax.jms.Queue javaxQueue = Wrapper.unwrapObject(queue, javax.jms.Queue.class);
        try {
            return new JakartaQueueReceiver(this.javaxQueueSession.createReceiver(javaxQueue));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        javax.jms.Queue javaxQueue = Wrapper.unwrapObject(queue, javax.jms.Queue.class);
        try {
            return new JakartaQueueReceiver(this.javaxQueueSession.createReceiver(javaxQueue, messageSelector));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        javax.jms.Queue javaxQueue = Wrapper.unwrapObject(queue, javax.jms.Queue.class);
        try {
            return new JakartaQueueSender(this.javaxQueueSession.createSender(javaxQueue));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

