/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaBytesMessage;
import com.github.marschall.jakartajmsadapter.JakartaMapMessage;
import com.github.marschall.jakartajmsadapter.JakartaMessage;
import com.github.marschall.jakartajmsadapter.JakartaMessageConsumer;
import com.github.marschall.jakartajmsadapter.JakartaMessageProducer;
import com.github.marschall.jakartajmsadapter.JakartaObjectMessage;
import com.github.marschall.jakartajmsadapter.JakartaQueue;
import com.github.marschall.jakartajmsadapter.JakartaQueueBrowser;
import com.github.marschall.jakartajmsadapter.JakartaStreamMessage;
import com.github.marschall.jakartajmsadapter.JakartaTemporaryQueue;
import com.github.marschall.jakartajmsadapter.JakartaTemporaryTopic;
import com.github.marschall.jakartajmsadapter.JakartaTextMessage;
import com.github.marschall.jakartajmsadapter.JakartaTopic;
import com.github.marschall.jakartajmsadapter.JakartaTopicSubscriber;
import com.github.marschall.jakartajmsadapter.JavaxMessageListener;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class JakartaSession
implements jakarta.jms.Session {
    private final Session javaxSession;
    private MessageListener listener;

    JakartaSession(Session javaxSession) {
        this.javaxSession = javaxSession;
    }

    public BytesMessage createBytesMessage() throws jakarta.jms.JMSException {
        try {
            return new JakartaBytesMessage(this.javaxSession.createBytesMessage());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MapMessage createMapMessage() throws jakarta.jms.JMSException {
        try {
            return new JakartaMapMessage(this.javaxSession.createMapMessage());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Message createMessage() throws jakarta.jms.JMSException {
        try {
            return new JakartaMessage(this.javaxSession.createMessage());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ObjectMessage createObjectMessage() throws jakarta.jms.JMSException {
        try {
            return new JakartaObjectMessage(this.javaxSession.createObjectMessage());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) throws jakarta.jms.JMSException {
        try {
            return new JakartaObjectMessage(this.javaxSession.createObjectMessage(object));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public StreamMessage createStreamMessage() throws jakarta.jms.JMSException {
        try {
            return new JakartaStreamMessage(this.javaxSession.createStreamMessage());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TextMessage createTextMessage() throws jakarta.jms.JMSException {
        try {
            return new JakartaTextMessage(this.javaxSession.createTextMessage());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TextMessage createTextMessage(String text) throws jakarta.jms.JMSException {
        try {
            return new JakartaTextMessage(this.javaxSession.createTextMessage(text));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public boolean getTransacted() throws jakarta.jms.JMSException {
        try {
            return this.javaxSession.getTransacted();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public int getAcknowledgeMode() throws jakarta.jms.JMSException {
        try {
            return this.javaxSession.getAcknowledgeMode();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void commit() throws jakarta.jms.JMSException {
        try {
            this.javaxSession.commit();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void rollback() throws jakarta.jms.JMSException {
        try {
            this.javaxSession.rollback();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void close() throws jakarta.jms.JMSException {
        try {
            this.javaxSession.close();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void recover() throws jakarta.jms.JMSException {
        try {
            this.javaxSession.recover();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageListener getMessageListener() throws jakarta.jms.JMSException {
        try {
            this.javaxSession.getMessageListener();
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws jakarta.jms.JMSException {
        JavaxMessageListener javaxListener = listener != null ? new JavaxMessageListener(listener) : null;
        try {
            this.javaxSession.setMessageListener((javax.jms.MessageListener)javaxListener);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
        this.listener = listener;
    }

    public void run() {
        this.javaxSession.run();
    }

    public MessageProducer createProducer(jakarta.jms.Destination destination) throws jakarta.jms.JMSException {
        try {
            return new JakartaMessageProducer(this.javaxSession.createProducer(Wrapper.unwrapObject(destination, Destination.class)));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createConsumer(jakarta.jms.Destination destination) throws jakarta.jms.JMSException {
        Destination javaxDestination = Wrapper.unwrapObject(destination, Destination.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createConsumer(javaxDestination));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createConsumer(jakarta.jms.Destination destination, String messageSelector) throws jakarta.jms.JMSException {
        Destination javaxDestination = Wrapper.unwrapObject(destination, Destination.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createConsumer(javaxDestination, messageSelector));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createConsumer(jakarta.jms.Destination destination, String messageSelector, boolean noLocal) throws jakarta.jms.JMSException {
        Destination javaxDestination = Wrapper.unwrapObject(destination, Destination.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createConsumer(javaxDestination, messageSelector, noLocal));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createSharedConsumer(jakarta.jms.Topic topic, String sharedSubscriptionName) throws jakarta.jms.JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createSharedConsumer(javaxTopic, sharedSubscriptionName));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createSharedConsumer(jakarta.jms.Topic topic, String sharedSubscriptionName, String messageSelector) throws jakarta.jms.JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createSharedConsumer(javaxTopic, sharedSubscriptionName, messageSelector));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.Queue createQueue(String queueName) throws jakarta.jms.JMSException {
        try {
            return new JakartaQueue(this.javaxSession.createQueue(queueName));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.Topic createTopic(String topicName) throws jakarta.jms.JMSException {
        try {
            return new JakartaTopic(this.javaxSession.createTopic(topicName));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TopicSubscriber createDurableSubscriber(jakarta.jms.Topic topic, String name) throws jakarta.jms.JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaTopicSubscriber(this.javaxSession.createDurableSubscriber(javaxTopic, name));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TopicSubscriber createDurableSubscriber(jakarta.jms.Topic topic, String name, String messageSelector, boolean noLocal) throws jakarta.jms.JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaTopicSubscriber(this.javaxSession.createDurableSubscriber(javaxTopic, name, messageSelector, noLocal));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createDurableConsumer(jakarta.jms.Topic topic, String name) throws jakarta.jms.JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createDurableConsumer(javaxTopic, name));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createDurableConsumer(jakarta.jms.Topic topic, String name, String messageSelector, boolean noLocal) throws jakarta.jms.JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createDurableConsumer(javaxTopic, name, messageSelector, noLocal));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createSharedDurableConsumer(jakarta.jms.Topic topic, String name) throws jakarta.jms.JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createSharedDurableConsumer(javaxTopic, name));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public MessageConsumer createSharedDurableConsumer(jakarta.jms.Topic topic, String name, String messageSelector) throws jakarta.jms.JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaMessageConsumer(this.javaxSession.createSharedDurableConsumer(javaxTopic, name, messageSelector));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public QueueBrowser createBrowser(jakarta.jms.Queue queue) throws jakarta.jms.JMSException {
        Queue javaxQueue = Wrapper.unwrapObject(queue, Queue.class);
        try {
            return new JakartaQueueBrowser(this.javaxSession.createBrowser(javaxQueue));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public QueueBrowser createBrowser(jakarta.jms.Queue queue, String messageSelector) throws jakarta.jms.JMSException {
        Queue javaxQueue = Wrapper.unwrapObject(queue, Queue.class);
        try {
            return new JakartaQueueBrowser(this.javaxSession.createBrowser(javaxQueue, messageSelector));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TemporaryQueue createTemporaryQueue() throws jakarta.jms.JMSException {
        try {
            return new JakartaTemporaryQueue(this.javaxSession.createTemporaryQueue());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TemporaryTopic createTemporaryTopic() throws jakarta.jms.JMSException {
        try {
            return new JakartaTemporaryTopic(this.javaxSession.createTemporaryTopic());
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void unsubscribe(String name) throws jakarta.jms.JMSException {
        try {
            this.javaxSession.unsubscribe(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

