/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JMSRuntimeExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Message;
import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;

final class JavaxCompletionListener
implements javax.jms.CompletionListener {
    private final CompletionListener jakartaCompletionListener;

    JavaxCompletionListener(CompletionListener jakartaCompletionListener) {
        Objects.requireNonNull(jakartaCompletionListener);
        this.jakartaCompletionListener = jakartaCompletionListener;
    }

    public void onCompletion(javax.jms.Message message) {
        Message jakartaMessage = JakartaMessage.fromJavax(message);
        this.jakartaCompletionListener.onCompletion(jakartaMessage);
    }

    public void onException(javax.jms.Message message, Exception exception) {
        Exception adapted;
        Message jakartaMessage = JakartaMessage.fromJavax(message);
        if (exception instanceof JMSException) {
            JMSException jmsException = (JMSException)((Object)exception);
            adapted = JMSExceptionUtil.adaptException(jmsException);
        } else if (exception instanceof JMSRuntimeException) {
            JMSRuntimeException jmsRuntimeException = (JMSRuntimeException)((Object)exception);
            adapted = JMSRuntimeExceptionUtil.adaptException(jmsRuntimeException);
        } else {
            adapted = exception;
        }
        this.jakartaCompletionListener.onException(jakartaMessage, adapted);
    }
}

