/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JakartaQueue;
import com.github.marschall.jakartajmsadapter.JakartaTemporaryQueue;
import com.github.marschall.jakartajmsadapter.JakartaTemporaryTopic;
import com.github.marschall.jakartajmsadapter.JakartaTopic;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;

public interface Wrapper {
    public Object getJavaxObject();

    public static Destination fromJavaxDestination(javax.jms.Destination destination) {
        if (destination == null) {
            return null;
        }
        if (destination instanceof Topic) {
            Topic topic = (Topic)destination;
            if (topic instanceof TemporaryTopic) {
                TemporaryTopic temporaryTopic = (TemporaryTopic)topic;
                return new JakartaTemporaryTopic(temporaryTopic);
            }
            return new JakartaTopic(topic);
        }
        if (destination instanceof Queue) {
            Queue queue = (Queue)destination;
            if (queue instanceof TemporaryQueue) {
                TemporaryQueue temporaryQueue = (TemporaryQueue)queue;
                return new JakartaTemporaryQueue(temporaryQueue);
            }
            return new JakartaQueue(queue);
        }
        throw new IllegalArgumentException("unknown destination type: " + destination.getClass());
    }

    public static <T> T unwrapObject(Object o, Class<T> clazz) throws JMSException {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Wrapper)) {
            throw new JMSException("not a wrapper: " + o.getClass());
        }
        Wrapper w = (Wrapper)o;
        Object javaxObject = w.getJavaxObject();
        if (!clazz.isInstance(javaxObject)) {
            throw new JMSException(o.getClass().getName() + " is not an instance of: " + clazz.getName());
        }
        return clazz.cast(javaxObject);
    }

    public static <T> T unwrapUnchecked(Object o, Class<T> clazz) throws JMSRuntimeException {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Wrapper)) {
            throw new JMSRuntimeException("not a wrapper: " + o.getClass());
        }
        Wrapper w = (Wrapper)o;
        Object javaxObject = w.getJavaxObject();
        if (!clazz.isInstance(javaxObject)) {
            throw new JMSRuntimeException(o.getClass().getName() + " is not an instance of: " + clazz.getName());
        }
        return clazz.cast(javaxObject);
    }
}

