/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import jakarta.jms.InvalidDestinationException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.TransactionInProgressException;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.ResourceAllocationException;
import javax.jms.TransactionRolledBackException;

final class JMSExceptionUtil {
    private JMSExceptionUtil() {
        throw new AssertionError((Object)"not instantiable");
    }

    static jakarta.jms.JMSException adaptException(JMSException e) {
        if (e instanceof IllegalStateException) {
            IllegalStateException illegalStateException = (IllegalStateException)e;
            return new jakarta.jms.IllegalStateException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof InvalidClientIDException) {
            InvalidClientIDException invalidClientIDException = (InvalidClientIDException)e;
            return new jakarta.jms.InvalidClientIDException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof javax.jms.InvalidDestinationException) {
            javax.jms.InvalidDestinationException invalidDestinationException = (javax.jms.InvalidDestinationException)e;
            return new InvalidDestinationException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof InvalidSelectorException) {
            InvalidSelectorException invalidSelectorException = (InvalidSelectorException)e;
            return new jakarta.jms.InvalidSelectorException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof JMSSecurityException) {
            JMSSecurityException jmsSecurityException = (JMSSecurityException)e;
            return new jakarta.jms.JMSSecurityException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof MessageEOFException) {
            MessageEOFException messageEOFException = (MessageEOFException)e;
            return new jakarta.jms.MessageEOFException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof MessageFormatException) {
            MessageFormatException messageFormatException = (MessageFormatException)e;
            return new jakarta.jms.MessageFormatException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof javax.jms.MessageNotReadableException) {
            javax.jms.MessageNotReadableException messageNotReadableException = (javax.jms.MessageNotReadableException)e;
            return new MessageNotReadableException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof javax.jms.MessageNotWriteableException) {
            javax.jms.MessageNotWriteableException messageNotWriteableException = (javax.jms.MessageNotWriteableException)e;
            return new MessageNotWriteableException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof ResourceAllocationException) {
            ResourceAllocationException resourceAllocationException = (ResourceAllocationException)e;
            return new jakarta.jms.ResourceAllocationException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof javax.jms.TransactionInProgressException) {
            javax.jms.TransactionInProgressException transactionInProgressException = (javax.jms.TransactionInProgressException)e;
            return new TransactionInProgressException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        if (e instanceof TransactionRolledBackException) {
            TransactionRolledBackException transactionRolledBackException = (TransactionRolledBackException)e;
            return new jakarta.jms.TransactionRolledBackException(e.getMessage(), e.getErrorCode(), (Exception)e);
        }
        return new jakarta.jms.JMSException(e.getMessage(), e.getErrorCode(), (Exception)e);
    }
}

