/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageNotWriteableRuntimeException;
import jakarta.jms.TransactionInProgressRuntimeException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.ResourceAllocationRuntimeException;
import javax.jms.TransactionRolledBackRuntimeException;

final class JMSRuntimeExceptionUtil {
    private JMSRuntimeExceptionUtil() {
        throw new AssertionError((Object)"not instantiable");
    }

    static JMSRuntimeException adaptException(javax.jms.JMSRuntimeException e) {
        if (e instanceof javax.jms.IllegalStateRuntimeException) {
            javax.jms.IllegalStateRuntimeException illegalStateException = (javax.jms.IllegalStateRuntimeException)e;
            return new IllegalStateRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidClientIDRuntimeException) {
            InvalidClientIDRuntimeException invalidClientIDException = (InvalidClientIDRuntimeException)e;
            return new jakarta.jms.InvalidClientIDRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof javax.jms.InvalidDestinationRuntimeException) {
            javax.jms.InvalidDestinationRuntimeException invalidDestinationException = (javax.jms.InvalidDestinationRuntimeException)e;
            return new InvalidDestinationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof javax.jms.InvalidSelectorRuntimeException) {
            javax.jms.InvalidSelectorRuntimeException invalidSelectorException = (javax.jms.InvalidSelectorRuntimeException)e;
            return new InvalidSelectorRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof JMSSecurityRuntimeException) {
            JMSSecurityRuntimeException jmsSecurityException = (JMSSecurityRuntimeException)e;
            return new jakarta.jms.JMSSecurityRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof javax.jms.MessageFormatRuntimeException) {
            javax.jms.MessageFormatRuntimeException messageFormatException = (javax.jms.MessageFormatRuntimeException)e;
            return new MessageFormatRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof javax.jms.MessageNotWriteableRuntimeException) {
            javax.jms.MessageNotWriteableRuntimeException messageNotWriteableException = (javax.jms.MessageNotWriteableRuntimeException)e;
            return new MessageNotWriteableRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof ResourceAllocationRuntimeException) {
            ResourceAllocationRuntimeException resourceAllocationException = (ResourceAllocationRuntimeException)e;
            return new jakarta.jms.ResourceAllocationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof javax.jms.TransactionInProgressRuntimeException) {
            javax.jms.TransactionInProgressRuntimeException transactionInProgressException = (javax.jms.TransactionInProgressRuntimeException)e;
            return new TransactionInProgressRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof TransactionRolledBackRuntimeException) {
            TransactionRolledBackRuntimeException transactionRolledBackException = (TransactionRolledBackRuntimeException)e;
            return new jakarta.jms.TransactionRolledBackRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        return new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
    }
}

