/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaServerSessionPool;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import java.util.Objects;
import javax.jms.ConnectionConsumer;

final class JakartaConnectionConsumer
implements jakarta.jms.ConnectionConsumer {
    private final ConnectionConsumer connectionConsumer;

    JakartaConnectionConsumer(ConnectionConsumer connectionConsumer) {
        Objects.requireNonNull(connectionConsumer);
        this.connectionConsumer = connectionConsumer;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        try {
            return new JakartaServerSessionPool(this.connectionConsumer.getServerSessionPool());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void close() throws JMSException {
        try {
            this.connectionConsumer.close();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

