/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSRuntimeExceptionUtil;
import com.github.marschall.jakartajmsadapter.JavaxCompletionListener;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;

final class JakartaJMSProducer
implements jakarta.jms.JMSProducer {
    private final JMSProducer javaxProducer;
    private CompletionListener async;

    JakartaJMSProducer(JMSProducer javaxProducer) {
        Objects.requireNonNull(javaxProducer);
        this.javaxProducer = javaxProducer;
    }

    public jakarta.jms.JMSProducer send(Destination destination, Message message) {
        javax.jms.Destination javaxDestination = Wrapper.unwrapUnchecked(destination, javax.jms.Destination.class);
        javax.jms.Message javaxMessage = Wrapper.unwrapUnchecked(message, javax.jms.Message.class);
        try {
            this.javaxProducer.send(javaxDestination, javaxMessage);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer send(Destination destination, String body) {
        javax.jms.Destination javaxDestination = Wrapper.unwrapUnchecked(destination, javax.jms.Destination.class);
        try {
            this.javaxProducer.send(javaxDestination, body);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer send(Destination destination, Map<String, Object> body) {
        javax.jms.Destination javaxDestination = Wrapper.unwrapUnchecked(destination, javax.jms.Destination.class);
        try {
            this.javaxProducer.send(javaxDestination, body);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer send(Destination destination, byte[] body) {
        javax.jms.Destination javaxDestination = Wrapper.unwrapUnchecked(destination, javax.jms.Destination.class);
        try {
            this.javaxProducer.send(javaxDestination, body);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer send(Destination destination, Serializable body) {
        javax.jms.Destination javaxDestination = Wrapper.unwrapUnchecked(destination, javax.jms.Destination.class);
        try {
            this.javaxProducer.send(javaxDestination, body);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setDisableMessageID(boolean value) {
        try {
            this.javaxProducer.setDisableMessageID(value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public boolean getDisableMessageID() {
        try {
            return this.javaxProducer.getDisableMessageID();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setDisableMessageTimestamp(boolean value) {
        try {
            this.javaxProducer.setDisableMessageTimestamp(value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        try {
            return this.javaxProducer.getDisableMessageTimestamp();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setDeliveryMode(int deliveryMode) {
        try {
            this.javaxProducer.setDeliveryMode(deliveryMode);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public int getDeliveryMode() {
        try {
            return this.javaxProducer.getDeliveryMode();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setPriority(int priority) {
        try {
            this.javaxProducer.setPriority(priority);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public int getPriority() {
        try {
            return this.javaxProducer.getPriority();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setTimeToLive(long timeToLive) {
        try {
            this.javaxProducer.setTimeToLive(timeToLive);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public long getTimeToLive() {
        try {
            return this.javaxProducer.getTimeToLive();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setDeliveryDelay(long deliveryDelay) {
        try {
            this.javaxProducer.setDeliveryDelay(deliveryDelay);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public long getDeliveryDelay() {
        try {
            return this.javaxProducer.getDeliveryDelay();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setAsync(CompletionListener completionListener) {
        JavaxCompletionListener javaxCompletionListener = completionListener != null ? new JavaxCompletionListener(completionListener) : null;
        try {
            this.javaxProducer.setAsync((javax.jms.CompletionListener)javaxCompletionListener);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        this.async = completionListener;
        return this;
    }

    public CompletionListener getAsync() {
        try {
            this.javaxProducer.getAsync();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this.async;
    }

    public jakarta.jms.JMSProducer setProperty(String name, boolean value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, byte value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, short value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, int value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, long value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, float value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, double value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, String value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer setProperty(String name, Object value) {
        try {
            this.javaxProducer.setProperty(name, value);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public jakarta.jms.JMSProducer clearProperties() {
        try {
            this.javaxProducer.clearProperties();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public boolean propertyExists(String name) {
        try {
            return this.javaxProducer.propertyExists(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public boolean getBooleanProperty(String name) {
        try {
            return this.javaxProducer.getBooleanProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public byte getByteProperty(String name) {
        try {
            return this.javaxProducer.getByteProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public short getShortProperty(String name) {
        try {
            return this.javaxProducer.getShortProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public int getIntProperty(String name) {
        try {
            return this.javaxProducer.getIntProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public long getLongProperty(String name) {
        try {
            return this.javaxProducer.getLongProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public float getFloatProperty(String name) {
        try {
            return this.javaxProducer.getFloatProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public double getDoubleProperty(String name) {
        try {
            return this.javaxProducer.getDoubleProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public String getStringProperty(String name) {
        try {
            return this.javaxProducer.getStringProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public Object getObjectProperty(String name) {
        try {
            return this.javaxProducer.getObjectProperty(name);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public Set<String> getPropertyNames() {
        try {
            return this.javaxProducer.getPropertyNames();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        try {
            this.javaxProducer.setJMSCorrelationIDAsBytes(correlationID);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        try {
            return this.javaxProducer.getJMSCorrelationIDAsBytes();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setJMSCorrelationID(String correlationID) {
        try {
            this.javaxProducer.setJMSCorrelationID(correlationID);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public String getJMSCorrelationID() {
        try {
            return this.javaxProducer.getJMSCorrelationID();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setJMSType(String type) {
        try {
            this.javaxProducer.setJMSType(type);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public String getJMSType() {
        try {
            return this.javaxProducer.getJMSType();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public jakarta.jms.JMSProducer setJMSReplyTo(Destination replyTo) {
        javax.jms.Destination javaxDestination = Wrapper.unwrapUnchecked(replyTo, javax.jms.Destination.class);
        try {
            this.javaxProducer.setJMSReplyTo(javaxDestination);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this;
    }

    public Destination getJMSReplyTo() {
        javax.jms.Destination javaxDestination;
        try {
            javaxDestination = this.javaxProducer.getJMSReplyTo();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return Wrapper.fromJavaxDestination(javaxDestination);
    }
}

