/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaConnection;
import com.github.marschall.jakartajmsadapter.JakartaConnectionConsumer;
import com.github.marschall.jakartajmsadapter.JakartaQueueSession;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import javax.jms.Connection;

final class JakartaQueueConnection
extends JakartaConnection
implements QueueConnection {
    private final javax.jms.QueueConnection javaxQueueConnection;

    JakartaQueueConnection(javax.jms.QueueConnection javaxQueueConnection) {
        super((Connection)javaxQueueConnection);
        this.javaxQueueConnection = javaxQueueConnection;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        try {
            return new JakartaQueueSession(this.javaxQueueConnection.createQueueSession(transacted, acknowledgeMode));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        javax.jms.Queue javaxQueue = Wrapper.unwrapObject(queue, javax.jms.Queue.class);
        javax.jms.ServerSessionPool javaxSessionPool = Wrapper.unwrapObject(sessionPool, javax.jms.ServerSessionPool.class);
        try {
            return new JakartaConnectionConsumer(this.javaxQueueConnection.createConnectionConsumer(javaxQueue, messageSelector, javaxSessionPool, maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

