/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaConnectionFactory;
import com.github.marschall.jakartajmsadapter.JakartaQueueConnection;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import javax.jms.ConnectionFactory;

public final class JakartaQueueConnectionFactory
extends JakartaConnectionFactory
implements QueueConnectionFactory {
    private final javax.jms.QueueConnectionFactory javaxQueueConnectionFactory;

    public JakartaQueueConnectionFactory(javax.jms.QueueConnectionFactory javaxQueueConnectionFactory) {
        super((ConnectionFactory)javaxQueueConnectionFactory);
        this.javaxQueueConnectionFactory = javaxQueueConnectionFactory;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        try {
            return new JakartaQueueConnection(this.javaxQueueConnectionFactory.createQueueConnection());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        try {
            return new JakartaQueueConnection(this.javaxQueueConnectionFactory.createQueueConnection(userName, password));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

