/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaConnection;
import com.github.marschall.jakartajmsadapter.JakartaConnectionConsumer;
import com.github.marschall.jakartajmsadapter.JakartaTopicSession;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.TopicSession;
import javax.jms.Connection;
import javax.jms.Topic;
import javax.jms.TopicConnection;

final class JakartaTopicConnection
extends JakartaConnection
implements jakarta.jms.TopicConnection {
    private final TopicConnection javaxTopicConnection;

    JakartaTopicConnection(TopicConnection javaxTopicConnection) {
        super((Connection)javaxTopicConnection);
        this.javaxTopicConnection = javaxTopicConnection;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        try {
            return new JakartaTopicSession(this.javaxTopicConnection.createTopicSession(transacted, acknowledgeMode));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ConnectionConsumer createConnectionConsumer(jakarta.jms.Topic Topic2, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(Topic2, Topic.class);
        javax.jms.ServerSessionPool javaxSessionPool = Wrapper.unwrapObject(sessionPool, javax.jms.ServerSessionPool.class);
        try {
            return new JakartaConnectionConsumer(this.javaxTopicConnection.createConnectionConsumer(javaxTopic, messageSelector, javaxSessionPool, maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

