/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaConnectionFactory;
import com.github.marschall.jakartajmsadapter.JakartaTopicConnection;
import jakarta.jms.JMSException;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import javax.jms.ConnectionFactory;

public final class JakartaTopicConnectionFactory
extends JakartaConnectionFactory
implements TopicConnectionFactory {
    private final javax.jms.TopicConnectionFactory javaxTopicConnectionFactory;

    public JakartaTopicConnectionFactory(javax.jms.TopicConnectionFactory javaxTopicConnectionFactory) {
        super((ConnectionFactory)javaxTopicConnectionFactory);
        this.javaxTopicConnectionFactory = javaxTopicConnectionFactory;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        try {
            return new JakartaTopicConnection(this.javaxTopicConnectionFactory.createTopicConnection());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        try {
            return new JakartaTopicConnection(this.javaxTopicConnectionFactory.createTopicConnection(userName, password));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

