/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaMessageProducer;
import com.github.marschall.jakartajmsadapter.JakartaTopic;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

final class JakartaTopicPublisher
extends JakartaMessageProducer
implements jakarta.jms.TopicPublisher {
    private final TopicPublisher javaxTopicPublisher;

    JakartaTopicPublisher(TopicPublisher javaxTopicPublisher) {
        super((MessageProducer)javaxTopicPublisher);
        this.javaxTopicPublisher = javaxTopicPublisher;
    }

    public jakarta.jms.Topic getTopic() throws JMSException {
        try {
            return new JakartaTopic(this.javaxTopicPublisher.getTopic());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void publish(Message message) throws JMSException {
        javax.jms.Message javaxMessage = Wrapper.unwrapObject(message, javax.jms.Message.class);
        try {
            this.javaxTopicPublisher.send(javaxMessage);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        javax.jms.Message javaxMessage = Wrapper.unwrapObject(message, javax.jms.Message.class);
        try {
            this.javaxTopicPublisher.send(javaxMessage, deliveryMode, priority, timeToLive);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void publish(jakarta.jms.Topic topic, Message message) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        javax.jms.Message javaxMessage = Wrapper.unwrapObject(message, javax.jms.Message.class);
        try {
            this.javaxTopicPublisher.send((Destination)javaxTopic, javaxMessage);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void publish(jakarta.jms.Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        javax.jms.Message javaxMessage = Wrapper.unwrapObject(message, javax.jms.Message.class);
        try {
            this.javaxTopicPublisher.send((Destination)javaxTopic, javaxMessage, deliveryMode, priority, timeToLive);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

