/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaSession;
import com.github.marschall.jakartajmsadapter.JakartaTopicPublisher;
import com.github.marschall.jakartajmsadapter.JakartaTopicSubscriber;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.JMSException;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;

final class JakartaTopicSession
extends JakartaSession
implements jakarta.jms.TopicSession {
    private final TopicSession javaxTopicSession;

    JakartaTopicSession(TopicSession javaxTopicSession) {
        super((Session)javaxTopicSession);
        this.javaxTopicSession = javaxTopicSession;
    }

    public TopicSubscriber createSubscriber(jakarta.jms.Topic topic) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaTopicSubscriber(this.javaxTopicSession.createSubscriber(javaxTopic));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TopicSubscriber createSubscriber(jakarta.jms.Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaTopicSubscriber(this.javaxTopicSession.createSubscriber(javaxTopic, messageSelector, noLocal));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public TopicPublisher createPublisher(jakarta.jms.Topic topic) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        try {
            return new JakartaTopicPublisher(this.javaxTopicSession.createPublisher(javaxTopic));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

