/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jdeps;

import com.github.marschall.jdeps.JDepsCommandUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="jdeps-report", threadSafe=true, requiresProject=true, defaultPhase=LifecyclePhase.SITE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class JdepsReportMojo
extends AbstractMavenReport {
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private Renderer siteRenderer;
    @Parameter(defaultValue="false", property="jdeps.summary")
    private boolean summary;
    @Parameter(defaultValue="false", property="jdeps.jdkInternals")
    private boolean jdkInternals;
    @Parameter(defaultValue="false", property="jdeps.apiOnly")
    private boolean apiOnly;
    @Parameter(defaultValue="false", property="jdeps.verbose")
    private boolean verbose;
    @Parameter(alias="verbose-level", property="jdeps.verboseLevel")
    private String verboseLevel;
    @Parameter
    private List<String> packages;
    @Parameter(property="jdeps.regex")
    private String regex;
    @Parameter(property="jdeps.filter")
    private String filter;
    @Parameter(property="jdeps.filterMode")
    private String filterMode;
    @Parameter(property="jdeps.include")
    private String include;
    @Parameter(defaultValue="false", property="jdeps.profile")
    private boolean profile;
    @Parameter(defaultValue="false", property="jdeps.recursive")
    private boolean recursive;
    @Parameter(defaultValue="false", property="jdeps.version")
    private boolean version;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}")
    private File reportOutputDirectory;

    public String getOutputName() {
        return "jdeps-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jdeps-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jdeps.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jdeps.description");
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        String jExecutable;
        Sink sink = this.getSink();
        try {
            jExecutable = this.getJdepsExecutable();
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to find jdeps command: " + e.getMessage(), (Exception)e);
        }
        Commandline cmd = this.buildCommandLine(jExecutable);
        String output = this.executeJDepsCommandLine(cmd);
        sink.head();
        sink.title();
        sink.text("JDeps report");
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text("JDeps report");
        sink.sectionTitle1_();
        sink.verbatim(true);
        sink.text(output);
        sink.verbatim_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private Commandline buildCommandLine(String jExecutable) throws MavenReportException {
        Commandline cmd = new Commandline();
        cmd.setExecutable(jExecutable);
        this.addApiOnly(cmd);
        this.addClassPathArg(cmd);
        this.addInclude(cmd);
        this.addJdkinternals(cmd);
        this.addPackagesArg(cmd);
        this.addProfileArg(cmd);
        this.addRegexArg(cmd);
        this.addRecursiveArg(cmd);
        this.addSummaryArg(cmd);
        this.addVerboseArg(cmd);
        this.addVerboseLevelArg(cmd);
        this.addFilterArg(cmd);
        this.addFilterModeArg(cmd);
        this.addVersionArg(cmd);
        this.addOutputArg(cmd);
        return cmd;
    }

    private void addPackagesArg(Commandline cmd) {
        if (this.packages != null && !this.packages.isEmpty()) {
            for (String each : this.packages) {
                cmd.createArg().setValue("-package");
                cmd.createArg().setValue(each);
            }
        }
    }

    private void addClassPathArg(Commandline cmd) throws MavenReportException {
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        if (!dependencyArtifacts.isEmpty()) {
            ArrayList<String> fileNames = new ArrayList<String>(dependencyArtifacts.size());
            for (Artifact artifact : dependencyArtifacts) {
                File file = artifact.getFile();
                if (file == null) continue;
                fileNames.add(file.getAbsolutePath());
            }
            String pathSeparator = System.getProperty("path.separator");
            if (pathSeparator == null) {
                throw new MavenReportException("Can't read path separator");
            }
            if (!fileNames.isEmpty()) {
                String classPath = StringUtils.join(fileNames.iterator(), (String)pathSeparator);
                cmd.createArg().setValue("-classpath");
                cmd.createArg().setValue(classPath);
            }
        }
    }

    private void addVerboseLevelArg(Commandline cmd) {
        if (this.verboseLevel != null) {
            cmd.createArg().setValue("-verbose:" + this.verboseLevel);
        }
    }

    private void addRegexArg(Commandline cmd) {
        if (this.regex != null) {
            cmd.createArg().setValue("-regex");
            cmd.createArg().setValue(this.regex);
        }
    }

    private void addInclude(Commandline cmd) {
        if (this.include != null) {
            cmd.createArg().setValue("-regex");
            cmd.createArg().setValue(this.include);
        }
    }

    private void addVerboseArg(Commandline cmd) {
        this.addBooleanArg(this.verbose, "-verbose", cmd);
    }

    private void addSummaryArg(Commandline cmd) {
        this.addBooleanArg(this.summary, "-summary", cmd);
    }

    private void addJdkinternals(Commandline cmd) {
        this.addBooleanArg(this.jdkInternals, "-jdkinternals", cmd);
    }

    private void addApiOnly(Commandline cmd) {
        this.addBooleanArg(this.apiOnly, "-apionly", cmd);
    }

    private void addProfileArg(Commandline cmd) {
        this.addBooleanArg(this.profile, "-profile", cmd);
    }

    private void addRecursiveArg(Commandline cmd) {
        this.addBooleanArg(this.recursive, "-recursive", cmd);
    }

    private void addFilterArg(Commandline cmd) {
        if (this.filter != null) {
            cmd.createArg().setValue("-filter");
            cmd.createArg().setValue(this.filter);
        }
    }

    private void addFilterModeArg(Commandline cmd) {
        if (this.filterMode != null) {
            switch (this.filterMode) {
                case "package": {
                    cmd.createArg().setValue("-filter:package");
                    break;
                }
                case "archive": {
                    cmd.createArg().setValue("-filter:archive");
                    break;
                }
                case "none": {
                    cmd.createArg().setValue("-filter:none");
                    break;
                }
            }
        }
    }

    private void addVersionArg(Commandline cmd) {
        this.addBooleanArg(this.version, "-version", cmd);
    }

    private void addBooleanArg(boolean flag, String name, Commandline cmd) {
        if (flag) {
            cmd.createArg().setValue(name);
        }
    }

    private void addOutputArg(Commandline cmd) {
        cmd.createArg().setFile(this.outputDirectory);
    }

    private String executeJDepsCommandLine(Commandline cmd) throws MavenReportException {
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            if (exitCode == 0) {
                return out.getOutput();
            }
            String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", "");
            StringBuilder msg = new StringBuilder("\nExit code: ");
            msg.append(exitCode);
            if (StringUtils.isNotEmpty((String)err.getOutput())) {
                msg.append(" - ").append(err.getOutput());
            }
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MavenReportException(msg.toString());
        }
        catch (CommandLineException e) {
            throw new MavenReportException("Unable to execute jdeps command: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getJdepsExecutable() throws IOException {
        JDepsCommandUtil jdepsCommandUtil = new JDepsCommandUtil(this.toolchainManager, this.getLog(), this.session);
        return jdepsCommandUtil.getJdepsExecutable();
    }

    protected String getOutputDirectory() {
        return this.reportOutputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }
}

