/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.junitlambda;

import com.github.marschall.junitlambda.Block;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.junit.Assert;

public final class LambdaAssert {
    private static final MethodHandle EAT_EXCEPTION;
    private static final MethodHandle CALL_PROTECTED;

    private LambdaAssert() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static void assertRaises(String message, Block block, Class<? extends Throwable> expected) {
        if (AssertionError.class.isAssignableFrom(expected)) {
            boolean raised = true;
            try {
                block.value();
                raised = false;
            }
            catch (AssertionError e) {
            }
            catch (Exception e) {
                LambdaAssert.exceptionCaught(null, expected, e);
            }
            if (!raised) {
                LambdaAssert.failNotRaised(null, expected);
            }
            return;
        }
        MethodHandle call = MethodHandles.insertArguments(CALL_PROTECTED, 0, message, block, expected);
        MethodHandle verification = MethodHandles.catchException(call, expected, EAT_EXCEPTION);
        try {
            verification.invokeWithArguments(new Object[0]);
        }
        catch (Throwable e) {
            throw new AssertionError("unexpected exception: " + e.getClass() + " expected: " + expected, e);
        }
    }

    public static void assertRaises(Block block, Class<? extends Throwable> expected) {
        LambdaAssert.assertRaises(null, block, expected);
    }

    private static void callProtected(String message, Block block, Class<? extends Throwable> expected) throws Exception {
        block.value();
        LambdaAssert.failNotRaised(message, expected);
    }

    private static void failNotRaised(String message, Class<? extends Throwable> expected) {
        Assert.fail((String)LambdaAssert.formatNotRaised(message, expected, null));
    }

    private static void eatException(Throwable exception) {
    }

    private static void exceptionCaught(String message, Class<? extends Throwable> expected, Throwable actual) {
        Assert.fail((String)LambdaAssert.formatNotRaised(message, expected, actual));
    }

    private static String formatNotRaised(String message, Class<? extends Throwable> expected, Throwable actual) {
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if (actual != null) {
            return formatted + "should have thrown: " + expected + " but did throw: " + actual.getClass();
        }
        return formatted + "should have thrown: " + expected + " but did not throw anything";
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            EAT_EXCEPTION = lookup.findStatic(LambdaAssert.class, "eatException", MethodType.methodType(Void.TYPE, Throwable.class));
            CALL_PROTECTED = lookup.findStatic(LambdaAssert.class, "callProtected", MethodType.methodType(Void.TYPE, String.class, Block.class, Class.class));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("could not initialize LambdaAssert", e);
        }
    }
}

