/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbsolutePath;
import com.github.marschall.memoryfilesystem.ElementPath;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import com.github.marschall.memoryfilesystem.RelativePath;
import com.github.marschall.memoryfilesystem.Root;
import com.github.marschall.memoryfilesystem.SingletonPath;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.List;

abstract class AbstractPath
implements Path {
    private final MemoryFileSystem fileSystem;

    AbstractPath(MemoryFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    static AbstractPath createAboslute(MemoryFileSystem fileSystem, Root root, List<String> nameElements) {
        if (nameElements.isEmpty()) {
            return root;
        }
        return new AbsolutePath(fileSystem, root, nameElements);
    }

    static AbstractPath createAboslute(MemoryFileSystem fileSystem, Root root, String nameElement) {
        return AbstractPath.createAboslute(fileSystem, root, Collections.singletonList(nameElement));
    }

    static AbstractPath createRelative(MemoryFileSystem fileSystem, List<String> nameElements) {
        int nameElementCount = nameElements.size();
        if (nameElementCount == 0) {
            return fileSystem.getEmptyPath();
        }
        if (nameElementCount == 1) {
            return AbstractPath.createRelative(fileSystem, nameElements.get(0));
        }
        return new RelativePath(fileSystem, nameElements);
    }

    static AbstractPath createRelative(MemoryFileSystem fileSystem, String nameElement) {
        return new SingletonPath(fileSystem, nameElement);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    MemoryFileSystem getMemoryFileSystem() {
        return this.fileSystem;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("memory file system does not support #toFile()");
    }

    @Override
    public final boolean startsWith(Path other) {
        if (!this.isSameFileSystem(other)) {
            return false;
        }
        return this.startsWith((AbstractPath)other);
    }

    abstract boolean startsWith(AbstractPath var1);

    @Override
    public final boolean endsWith(Path other) {
        if (!this.isSameFileSystem(other)) {
            return false;
        }
        return this.endsWith((AbstractPath)other);
    }

    abstract boolean endsWith(AbstractPath var1);

    @Override
    public final Path resolve(Path other) {
        this.assertSameFileSystem(other);
        AbstractPath otherPath = (AbstractPath)other;
        if (otherPath.isRoot()) {
            return other;
        }
        if (other.isAbsolute()) {
            return other;
        }
        if (otherPath.getNameCount() == 0) {
            return this;
        }
        return this.resolve((ElementPath)otherPath);
    }

    abstract Path resolve(ElementPath var1);

    @Override
    public final Path resolveSibling(Path other) {
        this.assertSameFileSystem(other);
        return this.resolveSibling((AbstractPath)other);
    }

    abstract Path resolveSibling(AbstractPath var1);

    abstract boolean isRoot();

    @Override
    public Path resolve(String other) {
        return this.resolve(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public final Path relativize(Path other) {
        this.assertSameFileSystem(other);
        return this.relativize((AbstractPath)other);
    }

    abstract Path relativize(AbstractPath var1);

    private boolean isSameFileSystem(Path other) {
        return other.getFileSystem() == this.getFileSystem();
    }

    private void assertSameFileSystem(Path other) {
        if (!this.isSameFileSystem(other)) {
            throw new ProviderMismatchException();
        }
    }

    @Override
    public int compareTo(Path other) {
        FileSystemProvider otherProvider;
        if (this == other) {
            return 0;
        }
        FileSystemProvider thisProvider = this.getFileSystem().provider();
        if (thisProvider != (otherProvider = other.getFileSystem().provider())) {
            String message = this + " can only be compared to paths of provider: " + thisProvider + " but " + other + " had provider: " + otherProvider;
            throw new ClassCastException(message);
        }
        AbstractPath otherPath = (AbstractPath)other;
        String otherFileSystemKey = otherPath.getMemoryFileSystem().getKey();
        String thisFileSystemKey = this.getMemoryFileSystem().getKey();
        int fileSystemComparison = thisFileSystemKey.compareTo(otherFileSystemKey);
        if (fileSystemComparison != 0) {
            return fileSystemComparison;
        }
        return this.compareTo(otherPath);
    }

    @Override
    abstract int compareTo(AbstractPath var1);
}

