/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.FileAttributeViews;
import com.github.marschall.memoryfilesystem.Options;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.HashSet;
import java.util.Set;

public final class Directories {
    private static final LinkOption[] NO_LINK_OPTIONS = new LinkOption[0];
    private static final LinkOption[] NOFOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    private Directories() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static void copyRecursive(Path source, Path target, CopyOption ... copyOptions) throws IOException {
        boolean sameFileSystem = source.getFileSystem() == target.getFileSystem();
        LinkOption[] linkOptions = Directories.linkOptions(copyOptions);
        boolean targetExists = Files.exists(target, linkOptions);
        boolean copyAttribues = Options.isCopyAttribues(copyOptions);
        Set<Class<? extends FileAttributeView>> supportedAttribueViews = Directories.supportedAttribueViews(source, target, sameFileSystem);
        if (!targetExists) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        DirectoryCopier copier = new DirectoryCopier(source, target, copyOptions, linkOptions, supportedAttribueViews, sameFileSystem, copyAttribues);
        Files.walkFileTree(source, copier);
        if (!targetExists && copyAttribues) {
            Directories.copyAttributes(source, target, sameFileSystem, supportedAttribueViews, linkOptions);
        }
    }

    private static LinkOption[] linkOptions(CopyOption[] copyOptions) {
        return Options.isFollowSymLinks(copyOptions) ? NO_LINK_OPTIONS : NOFOLLOW_LINKS;
    }

    private static Set<Class<? extends FileAttributeView>> supportedAttribueViews(Path source, Path target, boolean sameFileSystem) {
        Set<String> viewNames = source.getFileSystem().supportedFileAttributeViews();
        if (!sameFileSystem) {
            viewNames.retainAll(target.getFileSystem().supportedFileAttributeViews());
        }
        HashSet<Class<? extends FileAttributeView>> supportedAttribueViews = new HashSet<Class<? extends FileAttributeView>>(viewNames.size());
        for (String string : viewNames) {
            supportedAttribueViews.add(FileAttributeViews.mapAttributeViewName(string));
        }
        return supportedAttribueViews;
    }

    private static void copyAttributes(Path source, Path target, boolean sameFileSystem, Set<Class<? extends FileAttributeView>> attribueViews, LinkOption[] linkOptions) throws IOException {
        BasicFileAttributes basicAttributes = Files.readAttributes(target, BasicFileAttributes.class, linkOptions);
        BasicFileAttributeView basicView = Files.getFileAttributeView(target, BasicFileAttributeView.class, linkOptions);
        basicView.setTimes(basicAttributes.lastModifiedTime(), basicAttributes.lastAccessTime(), basicAttributes.creationTime());
        if (attribueViews.contains(PosixFileAttributeView.class)) {
            PosixFileAttributes posixAttributes = Files.readAttributes(target, PosixFileAttributes.class, linkOptions);
            PosixFileAttributeView posixView = Files.getFileAttributeView(target, PosixFileAttributeView.class, linkOptions);
            posixView.setPermissions(posixAttributes.permissions());
            Directories.copyOwner(source, target, sameFileSystem, posixAttributes, posixView, linkOptions);
            Directories.copyGroup(source, target, sameFileSystem, posixAttributes, posixView, linkOptions);
        }
        if (attribueViews.contains(UserDefinedFileAttributeView.class)) {
            UserDefinedFileAttributeView sourceAttributes = Files.getFileAttributeView(source, UserDefinedFileAttributeView.class, linkOptions);
            UserDefinedFileAttributeView targeAttributes = Files.getFileAttributeView(target, UserDefinedFileAttributeView.class, linkOptions);
            for (String each : sourceAttributes.list()) {
                int size;
                ByteBuffer buffer;
                int read = sourceAttributes.read(each, buffer = ByteBuffer.allocate(size = sourceAttributes.size(each)));
                if (read != size) {
                    throw new IOException("could not read attribute: " + each + " of " + source);
                }
                buffer.flip();
                int written = targeAttributes.write(each, buffer);
                if (written == size) continue;
                throw new IOException("could not read attribute: " + each + " of " + target);
            }
        }
        if (attribueViews.contains(DosFileAttributeView.class)) {
            DosFileAttributes dosAttributes = Files.readAttributes(target, DosFileAttributes.class, linkOptions);
            DosFileAttributeView dosView = Files.getFileAttributeView(target, DosFileAttributeView.class, linkOptions);
            dosView.setArchive(dosAttributes.isArchive());
            dosView.setHidden(dosAttributes.isHidden());
            dosView.setSystem(dosAttributes.isSystem());
            dosView.setReadOnly(dosAttributes.isReadOnly());
        }
    }

    private static void copyOwner(Path source, Path target, boolean sameFileSystem, PosixFileAttributes posixAttributes, PosixFileAttributeView posixView, LinkOption[] linkOptions) throws IOException {
        UserPrincipal owner = posixAttributes.owner();
        if (!sameFileSystem) {
            UserPrincipalLookupService userPrincipalLookupService = source.getFileSystem().getUserPrincipalLookupService();
            try {
                owner = userPrincipalLookupService.lookupPrincipalByName(owner.getName());
            }
            catch (UserPrincipalNotFoundException e) {
                return;
            }
        }
        posixView.setOwner(owner);
    }

    private static void copyGroup(Path source, Path target, boolean sameFileSystem, PosixFileAttributes posixAttributes, PosixFileAttributeView posixView, LinkOption[] linkOptions) throws IOException {
        GroupPrincipal group = posixAttributes.group();
        if (!sameFileSystem) {
            UserPrincipalLookupService userPrincipalLookupService = source.getFileSystem().getUserPrincipalLookupService();
            try {
                group = userPrincipalLookupService.lookupPrincipalByGroupName(group.getName());
            }
            catch (UserPrincipalNotFoundException e) {
                return;
            }
        }
        posixView.setGroup(group);
    }

    static final class DirectoryCopier
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path target;
        private final boolean sameProvider;
        private final LinkOption[] linkOptions;
        private final CopyOption[] copyOptions;
        private final boolean sameFileSystem;
        private final boolean copyAttribues;
        private final Set<Class<? extends FileAttributeView>> supportedAttribueViews;

        DirectoryCopier(Path source, Path target, CopyOption[] copyOptions, LinkOption[] linkOptions, Set<Class<? extends FileAttributeView>> supportedAttribueViews, boolean sameFileSystem, boolean copyAttribues) {
            this.source = source;
            this.target = target;
            this.copyOptions = copyOptions;
            this.linkOptions = linkOptions;
            this.supportedAttribueViews = supportedAttribueViews;
            this.sameFileSystem = sameFileSystem;
            this.copyAttribues = copyAttribues;
            this.sameProvider = source.getFileSystem().provider() == target.getFileSystem().provider();
        }

        private Path relativize(Path path) {
            Path relativized = this.source.relativize(path);
            if (this.sameProvider) {
                return this.target.resolve(relativized);
            }
            return this.target.resolve(relativized.toString());
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.relativize(file), this.copyOptions);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Files.createDirectory(this.relativize(dir), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (this.copyAttribues) {
                Directories.copyAttributes(this.source, this.relativize(dir), this.sameFileSystem, this.supportedAttribueViews, this.linkOptions);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

