/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.CompositeList;
import com.github.marschall.memoryfilesystem.ElementPath;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import com.github.marschall.memoryfilesystem.ParentReferenceList;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class NonEmptyPath
extends ElementPath {
    private final List<String> nameElements;

    NonEmptyPath(MemoryFileSystem fileSystem, List<String> nameElements) {
        super(fileSystem);
        this.nameElements = nameElements;
    }

    @Override
    List<String> getNameElements() {
        return this.nameElements;
    }

    @Override
    String getNameElement(int index) {
        return this.nameElements.get(index);
    }

    @Override
    String getLastNameElement() {
        return this.nameElements.get(this.nameElements.size() - 1);
    }

    int compareNameElements(List<String> otherElements) {
        int thisSize = this.nameElements.size();
        int otherSize = otherElements.size();
        Collator collator = this.getMemoryFileSystem().getCollator();
        for (int i = 0; i < thisSize; ++i) {
            String otherElement;
            if (i == otherSize) {
                return 1;
            }
            String thisElement = this.nameElements.get(i);
            int comparison = collator.compare(thisElement, otherElement = otherElements.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        if (otherSize > thisSize) {
            return -1;
        }
        return 0;
    }

    boolean equalElementsAs(List<String> otherElements) {
        int thisSize = this.nameElements.size();
        if (thisSize != otherElements.size()) {
            return false;
        }
        Collator collator = this.getMemoryFileSystem().getCollator();
        for (int i = 0; i < thisSize; ++i) {
            String otherElement;
            String thisElement = this.nameElements.get(i);
            if (collator.equals(thisElement, otherElement = otherElements.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path getFileName() {
        String lastElement = this.nameElements.get(this.nameElements.size() - 1);
        return NonEmptyPath.createRelative(this.getMemoryFileSystem(), lastElement);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.getMemoryFileSystem().toRealPath(this, options);
    }

    @Override
    boolean isRoot() {
        return false;
    }

    @Override
    public int getNameCount() {
        return this.nameElements.size();
    }

    @Override
    public boolean startsWith(String other) {
        Path path = this.getMemoryFileSystem().getPath(other, new String[0]);
        return this.startsWith(path);
    }

    void checkNameRange(int beginIndex, int endIndex) {
        int nameCount = this.getNameCount();
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex must not be negative but was " + beginIndex);
        }
        if (beginIndex >= nameCount) {
            throw new IllegalArgumentException("beginIndex must not be bigger than " + nameCount + " but was " + beginIndex);
        }
        if (endIndex <= beginIndex) {
            throw new IllegalArgumentException("endIndex must not be smaller than or equal to " + beginIndex + " but was " + beginIndex);
        }
        if (endIndex > nameCount) {
            throw new IllegalArgumentException("endIndex must not be bigger than " + nameCount + " but was " + beginIndex);
        }
    }

    @Override
    public boolean endsWith(String other) {
        Path path = this.getMemoryFileSystem().getPath(other, new String[0]);
        return this.endsWith(path);
    }

    @Override
    public Iterator<Path> iterator() {
        return new ElementIterator(this.getMemoryFileSystem(), this.nameElements.iterator());
    }

    protected int firstDifferenceIndex(List<?> l1, List<?> l2) {
        int endIndex = Math.min(l1.size(), l2.size());
        for (int i = 0; i < endIndex; ++i) {
            if (l1.get(i).equals(l2.get(i))) continue;
            return i;
        }
        return endIndex;
    }

    Path buildRelativePathAgainst(AbstractPath other) {
        ElementPath otherPath = (ElementPath)other;
        int firstDifferenceIndex = this.firstDifferenceIndex(this.getNameElements(), otherPath.getNameElements());
        List<Object> first = Collections.emptyList();
        if (firstDifferenceIndex < this.getNameCount()) {
            first = ParentReferenceList.create(this.getNameCount() - firstDifferenceIndex);
        }
        List<Object> second = Collections.emptyList();
        if (firstDifferenceIndex < other.getNameCount()) {
            second = otherPath.getNameElements().subList(firstDifferenceIndex, otherPath.getNameCount());
        }
        List<String> relativeElements = CompositeList.create(first, second);
        return NonEmptyPath.createRelative(this.getMemoryFileSystem(), relativeElements);
    }

    abstract List<String> handleDotDotNormalizationNotYetModified(List<String> var1, int var2, int var3);

    abstract void handleDotDotNormalizationAlreadyModified(List<String> var1);

    abstract List<String> handleSingleDotDot(List<String> var1);

    @Override
    public Path normalize() {
        List<String> nameElements = this.getNameElements();
        int nameElementsSize = nameElements.size();
        List<String> normalized = nameElements;
        boolean modified = false;
        for (int i = 0; i < nameElementsSize; ++i) {
            String each = nameElements.get(i);
            if (each.equals(".")) {
                if (modified) continue;
                if (nameElementsSize == 1) {
                    normalized = Collections.emptyList();
                    modified = true;
                    break;
                }
                if (nameElementsSize == 2) {
                    String element = i == 0 ? nameElements.get(1) : nameElements.get(0);
                    normalized = Collections.singletonList(element);
                    modified = true;
                    break;
                }
                normalized = new ArrayList(nameElementsSize - 1);
                if (i > 0) {
                    normalized.addAll(nameElements.subList(0, i));
                }
                modified = true;
                continue;
            }
            if (each.equals("..")) {
                if (modified) {
                    if (normalized.isEmpty()) continue;
                    this.handleDotDotNormalizationAlreadyModified(normalized);
                    continue;
                }
                if (nameElementsSize == 1) {
                    modified = (normalized = this.handleSingleDotDot(normalized)) != nameElements;
                    break;
                }
                normalized = this.handleDotDotNormalizationNotYetModified(nameElements, nameElementsSize, i);
                modified = normalized != nameElements;
                continue;
            }
            if (!modified) continue;
            normalized.add(each);
        }
        if (modified) {
            return this.newInstance(this.getMemoryFileSystem(), normalized);
        }
        return this;
    }

    abstract Path newInstance(MemoryFileSystem var1, List<String> var2);

    protected boolean endsWithRelativePath(AbstractPath other) {
        ElementPath otherPath = (ElementPath)other;
        int otherNameCount = otherPath.getNameCount();
        int thisNameCount = this.getNameCount();
        if (otherNameCount == 0) {
            return false;
        }
        if (otherNameCount > thisNameCount) {
            return false;
        }
        int offset = thisNameCount - otherNameCount;
        Collator collator = this.getMemoryFileSystem().getCollator();
        for (int i = 0; i < otherNameCount; ++i) {
            String otherElement;
            String thisElement = this.getNameElement(i + offset);
            if (collator.equals(thisElement, otherElement = otherPath.getNameElement(i))) continue;
            return false;
        }
        return true;
    }

    static final class ElementIterator
    implements Iterator<Path> {
        private final MemoryFileSystem fileSystem;
        private final Iterator<String> nameIterator;

        ElementIterator(MemoryFileSystem fileSystem, Iterator<String> nameIterator) {
            this.fileSystem = fileSystem;
            this.nameIterator = nameIterator;
        }

        @Override
        public boolean hasNext() {
            return this.nameIterator.hasNext();
        }

        @Override
        public Path next() {
            return AbstractPath.createRelative(this.fileSystem, this.nameIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove from a path iterator");
        }
    }
}

