/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.BlockChannel;
import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class MemoryFileLock
extends FileLock {
    static final AtomicIntegerFieldUpdater<MemoryFileLock> VALID_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MemoryFileLock.class, "valid");
    private static final int VALID = 1;
    private static final int INVALID = 0;
    private volatile int valid;

    MemoryFileLock(FileChannel channel, long position, long size, boolean shared) {
        super(channel, position, size, shared);
        VALID_UPDATER.set(this, 1);
    }

    MemoryFileLock(AsynchronousFileChannel channel, long position, long size, boolean shared) {
        super(channel, position, size, shared);
        VALID_UPDATER.set(this, 1);
    }

    @Override
    public boolean isValid() {
        return VALID_UPDATER.get(this) == 1;
    }

    @Override
    public void release() throws IOException {
        if (!this.acquiredBy().isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.isValid()) {
            FileChannel channel = this.channel();
            if (channel instanceof BlockChannel) {
                BlockChannel blockChannel = (BlockChannel)channel;
                blockChannel.removeLock(this);
            } else {
                throw new AssertionError((Object)("unknown channel type: " + channel));
            }
        }
    }

    void invalidate() {
        VALID_UPDATER.set(this, 0);
    }
}

