/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import java.nio.file.AccessDeniedException;

final class OneTimePermissionChecker {
    private volatile boolean checkPassed;
    private final PermissionChecker delegate;

    OneTimePermissionChecker(PermissionChecker delegate) {
        this.delegate = delegate;
        this.checkPassed = false;
    }

    void checkPermission() throws AccessDeniedException {
        if (!this.checkPassed) {
            this.delegate.checkPermission();
            this.checkPassed = true;
        }
    }

    @FunctionalInterface
    static interface PermissionChecker {
        public void checkPermission() throws AccessDeniedException;
    }
}

