/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.threeten.jpa.oracle.hibernate;

import com.github.marschall.threeten.jpa.oracle.hibernate.AbstractThreeTenType;
import com.github.marschall.threeten.jpa.oracle.impl.IntervalConverter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALDS;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class OracleDurationType
extends AbstractThreeTenType {
    public static final UserType INSTANCE = new OracleDurationType();
    public static final String NAME = "OracleDurationType";
    private static final int[] SQL_TYPES = new int[]{-104};

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class<?> returnedClass() {
        return Duration.class;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        OracleResultSet oracleResultSet = rs.unwrap(OracleResultSet.class);
        INTERVALDS intervalds = oracleResultSet.getINTERVALDS(names[0]);
        if (intervalds == null) {
            return null;
        }
        return IntervalConverter.intervaldsToDuration((INTERVALDS)intervalds);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = st.unwrap(OraclePreparedStatement.class);
        if (value == null) {
            oraclePreparedStatement.setINTERVALDS(index, null);
        } else {
            INTERVALDS intervalds = IntervalConverter.durationToIntervalds((Duration)((Duration)value));
            oraclePreparedStatement.setINTERVALDS(index, intervalds);
        }
    }
}

