/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.threeten.jpa.oracle.hibernate;

import com.github.marschall.threeten.jpa.oracle.hibernate.AbstractThreeTenType;
import com.github.marschall.threeten.jpa.oracle.impl.IntervalConverter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Period;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALYM;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class OraclePeriodType
extends AbstractThreeTenType {
    public static final UserType INSTANCE = new OraclePeriodType();
    public static final String NAME = "OraclePeriodType";
    private static final int[] SQL_TYPES = new int[]{-103};

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class<?> returnedClass() {
        return Period.class;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        OracleResultSet oracleResultSet = rs.unwrap(OracleResultSet.class);
        INTERVALYM intervalym = oracleResultSet.getINTERVALYM(names[0]);
        if (intervalym == null) {
            return null;
        }
        return IntervalConverter.intervalymToPeriod((INTERVALYM)intervalym);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = st.unwrap(OraclePreparedStatement.class);
        if (value == null) {
            oraclePreparedStatement.setINTERVALYM(index, null);
        } else {
            INTERVALYM intervalym = IntervalConverter.periodToIntervalym((Period)((Period)value));
            oraclePreparedStatement.setINTERVALYM(index, intervalym);
        }
    }
}

