/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.threeten.jpa.oracle.impl;

import java.time.Duration;
import java.time.Period;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;

public final class IntervalConverter {
    private static final int SIZE_INTERVALYM = 5;
    private static final int SIZE_INTERVALDS = 11;
    private static final int HIGH_BIT_FLAG = Integer.MIN_VALUE;

    public static Period intervalymToPeriod(INTERVALYM dbData) {
        if (dbData == null) {
            return null;
        }
        byte[] bytes = dbData.toBytes();
        int year = Byte.toUnsignedInt(bytes[0]) << 24 | Byte.toUnsignedInt(bytes[1]) << 16 | Byte.toUnsignedInt(bytes[2]) << 8 | Byte.toUnsignedInt(bytes[3]);
        int month = Byte.toUnsignedInt(bytes[4]) - 60;
        return Period.of(year ^= Integer.MIN_VALUE, month, 0);
    }

    public static INTERVALYM periodToIntervalym(Period attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.getDays() != 0) {
            throw new IllegalArgumentException("days are not supported");
        }
        byte[] bytes = IntervalConverter.newIntervalymBuffer();
        int year = attribute.getYears() ^ Integer.MIN_VALUE;
        bytes[0] = (byte)(year >> 24);
        bytes[1] = (byte)(year >> 16 & 0xFF);
        bytes[2] = (byte)(year >> 8 & 0xFF);
        bytes[3] = (byte)(year & 0xFF);
        int month = attribute.getMonths() + 60;
        bytes[4] = (byte)(month & 0xFF);
        return new INTERVALYM(bytes);
    }

    private static byte[] newIntervalymBuffer() {
        return new byte[5];
    }

    public static Duration intervaldsToDuration(INTERVALDS dbData) {
        if (dbData == null) {
            return null;
        }
        byte[] bytes = dbData.toBytes();
        int day = Byte.toUnsignedInt(bytes[0]) << 24 | Byte.toUnsignedInt(bytes[1]) << 16 | Byte.toUnsignedInt(bytes[2]) << 8 | Byte.toUnsignedInt(bytes[3]);
        int hour = Byte.toUnsignedInt(bytes[4]) - 60;
        int minute = Byte.toUnsignedInt(bytes[5]) - 60;
        int second = Byte.toUnsignedInt(bytes[6]) - 60;
        int nano = Byte.toUnsignedInt(bytes[7]) << 24 | Byte.toUnsignedInt(bytes[8]) << 16 | Byte.toUnsignedInt(bytes[9]) << 8 | Byte.toUnsignedInt(bytes[10]);
        return Duration.ofDays(day ^= Integer.MIN_VALUE).plusHours(hour).plusMinutes(minute).plusSeconds(second).plusNanos(nano ^= Integer.MIN_VALUE);
    }

    public static INTERVALDS durationToIntervalds(Duration attribute) {
        if (attribute == null) {
            return null;
        }
        byte[] bytes = IntervalConverter.newIntervaldsBuffer();
        long totalSeconds = attribute.getSeconds();
        if (attribute.isNegative()) {
            ++totalSeconds;
        }
        int day = Math.toIntExact(totalSeconds / 24L / 60L / 60L);
        int hour = (int)(totalSeconds / 60L / 60L - (long)day * 24L);
        int minute = (int)(totalSeconds / 60L - (long)day * 24L * 60L - (long)hour * 60L);
        int second = (int)(totalSeconds % 60L);
        int nano = attribute.isNegative() ? -(1000000000 - attribute.getNano()) : attribute.getNano();
        nano ^= Integer.MIN_VALUE;
        hour += 60;
        minute += 60;
        second += 60;
        bytes[0] = (byte)((day ^= Integer.MIN_VALUE) >> 24);
        bytes[1] = (byte)(day >> 16 & 0xFF);
        bytes[2] = (byte)(day >> 8 & 0xFF);
        bytes[3] = (byte)(day & 0xFF);
        bytes[4] = (byte)(hour & 0xFF);
        bytes[5] = (byte)(minute & 0xFF);
        bytes[6] = (byte)(second & 0xFF);
        bytes[7] = (byte)(nano >> 24);
        bytes[8] = (byte)(nano >> 16 & 0xFF);
        bytes[9] = (byte)(nano >> 8 & 0xFF);
        bytes[10] = (byte)(nano & 0xFF);
        return new INTERVALDS(bytes);
    }

    private static byte[] newIntervaldsBuffer() {
        return new byte[11];
    }

    private IntervalConverter() {
        throw new AssertionError((Object)"not instantiable");
    }
}

