/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.threeten.jpa.oracle.impl;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.ZONEIDMAP;

public final class TimestamptzConverter {
    private static final int INV_ZONEID = -1;
    private static final int SIZE_TIMESTAMPTZ = 13;
    private static final int SIZE_TIMESTAMP = 11;
    private static final int OFFSET_HOUR = 20;
    private static final int OFFSET_MINUTE = 60;
    private static final byte REGIONIDBIT = -128;

    public static TIMESTAMPTZ offsetDateTimeToTimestamptz(OffsetDateTime attribute) {
        if (attribute == null) {
            return null;
        }
        byte[] bytes = TimestamptzConverter.newTimestamptzBuffer();
        ZonedDateTime utc = attribute.atZoneSameInstant(ZoneOffset.UTC);
        TimestamptzConverter.writeDateTime(bytes, utc.toLocalDateTime());
        ZoneOffset offset = attribute.getOffset();
        TimestamptzConverter.writeZoneOffset(bytes, offset);
        return new TIMESTAMPTZ(bytes);
    }

    public static OffsetDateTime timestamptzToOffsetDateTime(TIMESTAMPTZ dbData) {
        if (dbData == null) {
            return null;
        }
        byte[] bytes = dbData.toBytes();
        OffsetDateTime utc = TimestamptzConverter.extractUtc(bytes);
        if (TimestamptzConverter.isFixedOffset(bytes)) {
            ZoneOffset offset = TimestamptzConverter.extractOffset(bytes);
            return utc.withOffsetSameInstant(offset);
        }
        ZoneId zoneId = TimestamptzConverter.extractZoneId(bytes);
        return utc.atZoneSameInstant(zoneId).toOffsetDateTime();
    }

    public static TIMESTAMPTZ zonedDateTimeToTimestamptz(ZonedDateTime attribute) {
        if (attribute == null) {
            return null;
        }
        byte[] bytes = TimestamptzConverter.newTimestamptzBuffer();
        ZonedDateTime utc = attribute.withZoneSameInstant(ZoneOffset.UTC);
        TimestamptzConverter.writeDateTime(bytes, utc.toLocalDateTime());
        String zoneId = attribute.getZone().getId();
        int regionCode = ZONEIDMAP.getID((String)zoneId);
        if (TimestamptzConverter.isValidRegionCode(regionCode)) {
            TimestamptzConverter.writeZoneId(bytes, regionCode);
        } else {
            TimestamptzConverter.writeZoneOffset(bytes, attribute.getOffset());
        }
        return new TIMESTAMPTZ(bytes);
    }

    public static ZonedDateTime timestamptzToZonedDateTime(TIMESTAMPTZ dbData) {
        if (dbData == null) {
            return null;
        }
        byte[] bytes = dbData.toBytes();
        OffsetDateTime utc = TimestamptzConverter.extractUtc(bytes);
        if (TimestamptzConverter.isFixedOffset(bytes)) {
            ZoneOffset offset = TimestamptzConverter.extractOffset(bytes);
            return utc.atZoneSameInstant(offset);
        }
        ZoneId zoneId = TimestamptzConverter.extractZoneId(bytes);
        return utc.atZoneSameInstant(zoneId);
    }

    public static TIMESTAMP localDateTimeToTimestamp(LocalDateTime attribute) {
        if (attribute == null) {
            return null;
        }
        byte[] bytes = TimestamptzConverter.newTimestampBuffer();
        TimestamptzConverter.writeDateTime(bytes, attribute);
        return new TIMESTAMP(bytes);
    }

    public static LocalDateTime timestampToLocalDateTime(TIMESTAMP dbData) {
        if (dbData == null) {
            return null;
        }
        byte[] bytes = dbData.toBytes();
        return TimestamptzConverter.extractLocalDateTime(bytes);
    }

    private static LocalDateTime extractLocalDateTime(byte[] bytes) {
        int year = (Byte.toUnsignedInt(bytes[0]) - 100) * 100 + (Byte.toUnsignedInt(bytes[1]) - 100);
        byte month = bytes[2];
        byte dayOfMonth = bytes[3];
        int hour = bytes[4] - 1;
        int minute = bytes[5] - 1;
        int second = bytes[6] - 1;
        int nanoOfSecond = Byte.toUnsignedInt(bytes[7]) << 24 | Byte.toUnsignedInt(bytes[8]) << 16 | Byte.toUnsignedInt(bytes[9]) << 8 | Byte.toUnsignedInt(bytes[10]);
        return LocalDateTime.of(year, month, (int)dayOfMonth, hour, minute, second, nanoOfSecond);
    }

    private static OffsetDateTime extractUtc(byte[] bytes) {
        return OffsetDateTime.of(TimestamptzConverter.extractLocalDateTime(bytes), ZoneOffset.UTC);
    }

    private static boolean isFixedOffset(byte[] bytes) {
        return (bytes[11] & 0xFFFFFF80) == 0;
    }

    private static ZoneOffset extractOffset(byte[] bytes) {
        int hours = bytes[11] - 20;
        int minutes = bytes[12] - 60;
        if (hours == 0 && minutes == 0) {
            return ZoneOffset.UTC;
        }
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }

    private static ZoneId extractZoneId(byte[] bytes) {
        int regionCode = (bytes[11] & 0x7F) << 6;
        String regionName = ZONEIDMAP.getRegion((int)(regionCode += (bytes[12] & 0xFC) >> 2));
        return ZoneId.of(regionName);
    }

    private static boolean isValidRegionCode(int regionCode) {
        return regionCode != -1;
    }

    private static byte[] newTimestamptzBuffer() {
        return new byte[13];
    }

    private static byte[] newTimestampBuffer() {
        return new byte[11];
    }

    private static void writeDateTime(byte[] bytes, LocalDateTime utc) {
        int year = utc.getYear();
        bytes[0] = (byte)(year / 100 + 100);
        bytes[1] = (byte)(year % 100 + 100);
        bytes[2] = (byte)utc.getMonthValue();
        bytes[3] = (byte)utc.getDayOfMonth();
        bytes[4] = (byte)(utc.getHour() + 1);
        bytes[5] = (byte)(utc.getMinute() + 1);
        bytes[6] = (byte)(utc.getSecond() + 1);
        int nano = utc.getNano();
        bytes[7] = (byte)(nano >> 24);
        bytes[8] = (byte)(nano >> 16 & 0xFF);
        bytes[9] = (byte)(nano >> 8 & 0xFF);
        bytes[10] = (byte)(nano & 0xFF);
    }

    private static void writeZoneOffset(byte[] bytes, ZoneOffset offset) {
        int totalMinutes = offset.getTotalSeconds() / 60;
        bytes[11] = (byte)(totalMinutes / 60 + 20);
        bytes[12] = (byte)(totalMinutes % 60 + 60);
    }

    private static void writeZoneId(byte[] bytes, int regionCode) {
        bytes[11] = (byte)(0xFFFFFF80 | (regionCode & 0x1FC0) >>> 6);
        bytes[12] = (byte)((regionCode & 0x3F) << 2);
    }

    private TimestamptzConverter() {
        throw new AssertionError((Object)"not instantiable");
    }
}

