/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chronos.chronodb.api.Order;
import org.chronos.chronodb.api.exceptions.InvalidTransactionBranchException;
import org.chronos.chronodb.api.exceptions.InvalidTransactionTimestampException;
import org.chronos.chronosphere.api.ChronoSphereBranchManager;
import org.chronos.chronosphere.api.ChronoSphereEPackageManager;
import org.chronos.chronosphere.api.ChronoSphereFactory;
import org.chronos.chronosphere.api.ChronoSphereIndexManager;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.emf.internal.api.ChronoEObjectInternal;
import org.chronos.chronosphere.emf.internal.util.EMFUtils;
import org.chronos.chronosphere.internal.configuration.api.ChronoSphereConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public interface ChronoSphere
extends AutoCloseable {
    public static final ChronoSphereFactory FACTORY = ChronoSphereFactory.INSTANCE;

    public ChronoSphereConfiguration getConfiguration();

    public ChronoSphereTransaction tx();

    public ChronoSphereTransaction tx(long var1) throws InvalidTransactionTimestampException;

    public ChronoSphereTransaction tx(Date var1) throws InvalidTransactionTimestampException;

    public ChronoSphereTransaction tx(String var1) throws InvalidTransactionBranchException;

    public ChronoSphereTransaction tx(String var1, long var2) throws InvalidTransactionBranchException, InvalidTransactionTimestampException;

    public ChronoSphereTransaction tx(String var1, Date var2) throws InvalidTransactionBranchException, InvalidTransactionTimestampException;

    default public void batchInsertModelData(String xmiContent) {
        Preconditions.checkNotNull((Object)xmiContent, (Object)"Precondition violation - argument 'xmiContent' must not be NULL!");
        this.batchInsertModelData("master", xmiContent);
    }

    default public void batchInsertModelData(String branch, String xmiContent) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((boolean)this.getBranchManager().existsBranch(branch), (Object)"Precondition violation - argument 'branch' must refer to an existing branch!");
        Preconditions.checkNotNull((Object)xmiContent, (Object)"Precondition violation - argument 'xmiContent' must not be NULL!");
        Set<EPackage> ePackages = this.getEPackageManager().getRegisteredEPackages();
        List<EObject> eObjectsFromXMI = EMFUtils.readEObjectsFromXMI(xmiContent, ePackages);
        this.batchInsertModelData(branch, eObjectsFromXMI);
    }

    default public void batchInsertModelData(File xmiFile) {
        Preconditions.checkNotNull((Object)xmiFile, (Object)"Precondition violation - argument 'xmiFile' must not be NULL!");
        EMFUtils.assertIsXMIFile(xmiFile);
        this.batchInsertModelData("master", xmiFile);
    }

    default public void batchInsertModelData(String branch, File xmiFile) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((boolean)this.getBranchManager().existsBranch(branch), (Object)"Precondition violation - argument 'branch' must refer to an existing branch!");
        Preconditions.checkNotNull((Object)xmiFile, (Object)"Precondition violation - argument 'xmiFile' must not be NULL!");
        EMFUtils.assertIsXMIFile(xmiFile);
        ResourceSet resourceSet = EMFUtils.createResourceSet();
        for (EPackage ePackage : this.getEPackageManager().getRegisteredEPackages()) {
            resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
        Resource resource = resourceSet.getResource(URI.createFileURI((String)xmiFile.getAbsolutePath()), true);
        this.batchInsertModelData(branch, (Iterable<EObject>)resource.getContents());
    }

    default public void batchInsertModelData(EObject model) {
        Preconditions.checkNotNull((Object)model, (Object)"Precondition violation - argument 'model' must not be NULL!");
        Preconditions.checkArgument((boolean)(model instanceof ChronoEObjectInternal), (Object)"Precondition violation - argument 'model' is no ChronoEObject!");
        ChronoEObjectInternal chronoEObject = (ChronoEObjectInternal)model;
        Preconditions.checkArgument((!chronoEObject.isAttached() ? 1 : 0) != 0, (Object)"Precondition violation - the given EObject is already attached to a repository!");
        this.batchInsertModelData("master", model);
    }

    default public void batchInsertModelData(String branch, EObject model) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((boolean)this.getBranchManager().existsBranch(branch), (Object)"Precondition violation - argument 'branch' must refer to an existing branch!");
        Preconditions.checkNotNull((Object)model, (Object)"Precondition violation - argument 'model' must not be NULL!");
        Preconditions.checkArgument((boolean)(model instanceof ChronoEObjectInternal), (Object)"Precondition violation - argument 'model' is no ChronoEObject!");
        ChronoEObjectInternal chronoEObject = (ChronoEObjectInternal)model;
        Preconditions.checkArgument((!chronoEObject.isAttached() ? 1 : 0) != 0, (Object)"Precondition violation - the given EObject is already attached to a repository!");
        this.batchInsertModelData(branch, (Iterator<EObject>)Iterators.singletonIterator((Object)model));
    }

    default public void batchInsertModelData(Iterable<EObject> model) {
        Preconditions.checkNotNull(model, (Object)"Precondition violation - argument 'model' must not be NULL!");
        this.batchInsertModelData(model.iterator());
    }

    default public void batchInsertModelData(String branch, Iterable<EObject> model) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkNotNull(model, (Object)"Precondition violation - argument 'model' must not be NULL!");
        Preconditions.checkArgument((boolean)this.getBranchManager().existsBranch(branch), (Object)"Precondition violation - argument 'branch' does not refer to an existing branch!");
        this.batchInsertModelData(branch, model.iterator());
    }

    default public void batchInsertModelData(Iterator<EObject> model) {
        Preconditions.checkNotNull(model, (Object)"Precondition violation - argument 'model' must not be NULL!");
        this.batchInsertModelData("master", model);
    }

    public void batchInsertModelData(String var1, Iterator<EObject> var2);

    public ChronoSphereBranchManager getBranchManager();

    default public ChronoSphereIndexManager getIndexManager() {
        return this.getIndexManager("master");
    }

    public ChronoSphereIndexManager getIndexManager(String var1);

    public ChronoSphereEPackageManager getEPackageManager();

    @Override
    public void close();

    public boolean isClosed();

    default public boolean isOpen() {
        return !this.isClosed();
    }

    default public long getNow() {
        return this.getNow("master");
    }

    public long getNow(String var1);

    default public Object getCommitMetadata(long timestamp) {
        return this.getCommitMetadata("master", timestamp);
    }

    public Object getCommitMetadata(String var1, long var2);

    default public Iterator<Long> getCommitTimestampsBetween(long from, long to) {
        return this.getCommitTimestampsBetween("master", from, to);
    }

    default public Iterator<Long> getCommitTimestampsBetween(String branch, long from, long to) {
        return this.getCommitTimestampsBetween(branch, from, to, Order.DESCENDING);
    }

    default public Iterator<Long> getCommitTimestampsBewteen(long from, long to, Order order) {
        return this.getCommitTimestampsBetween("master", from, to, order);
    }

    default public Iterator<Long> getCommitTimestampsBetween(long from, long to, Order order) {
        return this.getCommitTimestampsBetween("master", from, to, order);
    }

    public Iterator<Long> getCommitTimestampsBetween(String var1, long var2, long var4, Order var6);

    default public Iterator<Map.Entry<Long, Object>> getCommitMetadataBetween(long from, long to) {
        return this.getCommitMetadataBetween("master", from, to, Order.DESCENDING);
    }

    default public Iterator<Map.Entry<Long, Object>> getCommitMetadataBetween(String branch, long from, long to) {
        return this.getCommitMetadataBetween(branch, from, to, Order.DESCENDING);
    }

    default public Iterator<Map.Entry<Long, Object>> getCommitMetadataBetween(long from, long to, Order order) {
        return this.getCommitMetadataBetween("master", from, to, order);
    }

    public Iterator<Map.Entry<Long, Object>> getCommitMetadataBetween(String var1, long var2, long var4, Order var6);

    default public Iterator<Long> getCommitTimestampsPaged(long minTimestamp, long maxTimestamp, int pageSize, int pageIndex, Order order) {
        return this.getCommitTimestampsPaged("master", minTimestamp, maxTimestamp, pageSize, pageIndex, order);
    }

    public Iterator<Long> getCommitTimestampsPaged(String var1, long var2, long var4, int var6, int var7, Order var8);

    default public Iterator<Map.Entry<Long, Object>> getCommitMetadataPaged(long minTimestamp, long maxTimestamp, int pageSize, int pageIndex, Order order) {
        return this.getCommitMetadataPaged("master", minTimestamp, maxTimestamp, pageSize, pageIndex, order);
    }

    public Iterator<Map.Entry<Long, Object>> getCommitMetadataPaged(String var1, long var2, long var4, int var6, int var7, Order var8);

    default public int countCommitTimestampsBetween(long from, long to) {
        return this.countCommitTimestampsBetween("master", from, to);
    }

    public int countCommitTimestampsBetween(String var1, long var2, long var4);

    default public int countCommitTimestamps() {
        return this.countCommitTimestamps("master");
    }

    public int countCommitTimestamps(String var1);
}

