/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.api.query;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.chronos.chronosphere.api.query.EObjectQueryStepBuilder;
import org.chronos.chronosphere.api.query.NumericQueryStepBuilder;
import org.chronos.chronosphere.api.query.QueryStepBuilder;
import org.chronos.chronosphere.api.query.UntypedQueryStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryAllReferencingEObjectsQueryStep;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryAsEObjectStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEAllContentsStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEContainerStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEContentsStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEGetReferenceStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryHasFeatureValueStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryInstanceOfEClassNameStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryInstanceOfEClassStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsByteStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsDoubleStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsFloatStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsIntegerStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsLongStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsShortStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryAndStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryAsBooleanStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryAsCharacterStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEGetAttributeStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEGetByNameStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEObjectReifyStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryFilterStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryMapStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryNamedStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryOrStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryUnionStepBuilder;
import org.chronos.chronosphere.impl.query.traversal.TraversalSource;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SubQuery {
    public static <S> UntypedQueryStepBuilder<S, S> filter(Predicate<S> predicate) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryFilterStepBuilder(source, predicate);
    }

    public static <S, E> UntypedQueryStepBuilder<S, E> map(Function<S, E> function) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryMapStepBuilder(source, function);
    }

    public static <S> UntypedQueryStepBuilder<S, S> notNull() {
        return SubQuery.filter(Objects::nonNull);
    }

    public static <S> EObjectQueryStepBuilder<S> asEObject() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryAsEObjectStepBuilder(source);
    }

    public static <S> QueryStepBuilder<S, Boolean> asBoolean() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryAsBooleanStepBuilder(source);
    }

    public static <S> NumericQueryStepBuilder<S, Byte> asByte() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new NumericQueryAsByteStepBuilder(source);
    }

    public static <S> NumericQueryStepBuilder<S, Short> asShort() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new NumericQueryAsShortStepBuilder(source);
    }

    public static <S> QueryStepBuilder<S, Character> asCharacter() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryAsCharacterStepBuilder(source);
    }

    public static <S> NumericQueryStepBuilder<S, Integer> asInteger() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new NumericQueryAsIntegerStepBuilder(source);
    }

    public static <S> NumericQueryStepBuilder<S, Long> asLong() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new NumericQueryAsLongStepBuilder(source);
    }

    public static <S> NumericQueryStepBuilder<S, Float> asFloat() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new NumericQueryAsFloatStepBuilder(source);
    }

    public static <S> NumericQueryStepBuilder<S, Double> asDouble() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new NumericQueryAsDoubleStepBuilder(source);
    }

    public static <S> QueryStepBuilder<S, S> named(String stepName) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryNamedStepBuilder(source, stepName);
    }

    @SafeVarargs
    public static <S> QueryStepBuilder<S, Object> union(QueryStepBuilder<S, ?> ... subqueries) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryUnionStepBuilder(source, subqueries);
    }

    @SafeVarargs
    public static <S> QueryStepBuilder<S, S> and(QueryStepBuilder<S, ?> ... subqueries) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryAndStepBuilder(source, subqueries);
    }

    @SafeVarargs
    public static <S> QueryStepBuilder<S, S> or(QueryStepBuilder<S, ?> ... subqueries) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryOrStepBuilder(source, subqueries);
    }

    public static EObjectQueryStepBuilder<EObject> has(String eStructuralFeatureName, Object value) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        ObjectQueryEObjectReifyStepBuilder reified = new ObjectQueryEObjectReifyStepBuilder(source);
        ObjectQueryFilterStepBuilder filtered = new ObjectQueryFilterStepBuilder(reified, eObject -> {
            if (eObject == null) {
                return false;
            }
            EClass eClass = eObject.eClass();
            EStructuralFeature feature = eClass.getEStructuralFeature(eStructuralFeatureName);
            if (feature == null) {
                return false;
            }
            return com.google.common.base.Objects.equal((Object)eObject.eGet(feature), (Object)value);
        });
        return new EObjectQueryAsEObjectStepBuilder(filtered);
    }

    public static EObjectQueryStepBuilder<EObject> has(EStructuralFeature eStructuralFeature, Object value) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryHasFeatureValueStepBuilder<EObject>(source, eStructuralFeature, value);
    }

    public static EObjectQueryStepBuilder<EObject> isInstanceOf(EClass eClass) {
        return SubQuery.isInstanceOf(eClass, true);
    }

    public static EObjectQueryStepBuilder<EObject> isInstanceOf(EClass eClass, boolean allowSubclasses) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryInstanceOfEClassStepBuilder<EObject>(source, eClass, allowSubclasses);
    }

    public static EObjectQueryStepBuilder<EObject> isInstanceOf(String eClassName) {
        return SubQuery.isInstanceOf(eClassName, true);
    }

    public static EObjectQueryStepBuilder<EObject> isInstanceOf(String eClassName, boolean allowSubclasses) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryInstanceOfEClassNameStepBuilder<EObject>(source, eClassName, allowSubclasses);
    }

    public static UntypedQueryStepBuilder<EObject, Object> eGet(String eStructuralFeatureName) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryEGetByNameStepBuilder<EObject>(source, eStructuralFeatureName);
    }

    public static EObjectQueryStepBuilder<EObject> eGet(EReference eReference) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryEGetReferenceStepBuilder<EObject>(source, eReference);
    }

    public static UntypedQueryStepBuilder<EObject, Object> eGet(EAttribute eAttribute) {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new ObjectQueryEGetAttributeStepBuilder<EObject>(source, eAttribute);
    }

    public static EObjectQueryStepBuilder<EObject> eContainer() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryEContainerStepBuilder<EObject>(source);
    }

    public static EObjectQueryStepBuilder<EObject> eContents() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryEContentsStepBuilder<EObject>(source);
    }

    public static EObjectQueryStepBuilder<EObject> eAllContents() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryEAllContentsStepBuilder<EObject>(source);
    }

    public static EObjectQueryStepBuilder<EObject> allReferencingEObjects() {
        TraversalSource source = TraversalSource.createAnonymousSource();
        return new EObjectQueryAllReferencingEObjectsQueryStep<EObject>(source);
    }
}

