/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.emf.impl;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.emf.internal.api.ChronoEObjectInternal;
import org.chronos.chronosphere.emf.internal.api.ChronoEObjectLifecycle;
import org.chronos.chronosphere.emf.internal.impl.store.ChronoEStore;
import org.chronos.chronosphere.emf.internal.impl.store.OwnedTransientEStore;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.impl.MinimalEStoreEObjectImpl;

public class ChronoEObjectImpl
extends MinimalEStoreEObjectImpl
implements ChronoEObject,
ChronoEObjectInternal {
    private String id;
    private ChronoEObjectLifecycle lifecycleStatus;
    private ChronoEStore eStore;

    public ChronoEObjectImpl() {
        this.id = UUID.randomUUID().toString();
        this.lifecycleStatus = ChronoEObjectLifecycle.TRANSIENT;
        this.eSetStore(new OwnedTransientEStore(this));
    }

    public ChronoEObjectImpl(String id, EClass eClass) {
        Preconditions.checkNotNull((Object)id, (Object)"Precondition violation - argument 'id' must not be NULL!");
        this.id = id;
        this.lifecycleStatus = ChronoEObjectLifecycle.TRANSIENT;
        this.eSetStore(new OwnedTransientEStore(this));
        this.eSetClass(eClass);
    }

    public ChronoEObjectImpl(String id, EClass eClass, ChronoEStore eStore) {
        Preconditions.checkNotNull((Object)id, (Object)"Precondition violation - argument 'id' must not be NULL!");
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        Preconditions.checkNotNull((Object)eStore, (Object)"Precondition violation - argument 'eStore' must not be NULL!");
        this.id = id;
        this.eSetClass(eClass);
        this.eStore = eStore;
        this.lifecycleStatus = ChronoEObjectLifecycle.PERSISTENT_CLEAN;
    }

    protected boolean eIsCaching() {
        return false;
    }

    public Object dynamicGet(int dynamicFeatureID) {
        EStructuralFeature feature = this.eDynamicFeature(dynamicFeatureID);
        if (feature.isMany()) {
            return new EStoreEObjectImpl.BasicEStoreEList((InternalEObject)this, feature);
        }
        return this.eStore().get(this, feature, -1);
    }

    public void dynamicSet(int dynamicFeatureID, Object value) {
        EStructuralFeature feature = this.eDynamicFeature(dynamicFeatureID);
        if (feature.isMany()) {
            this.eStore().unset(this, feature);
            EList collection = (EList)value;
            for (int index = 0; index < collection.size(); ++index) {
                this.eStore().set(this, feature, index, value);
            }
        } else {
            this.eStore().set(this, feature, -1, value);
        }
    }

    public void dynamicUnset(int dynamicFeatureID) {
        EStructuralFeature feature = this.eDynamicFeature(dynamicFeatureID);
        this.eStore().unset(this, feature);
    }

    public void eDynamicUnset(EStructuralFeature eFeature) {
        this.eStore().unset(this, eFeature);
    }

    protected void eDynamicUnset(int dynamicFeatureID, EStructuralFeature eFeature) {
        this.eStore().unset(this, eFeature);
    }

    protected void eBasicSetContainer(InternalEObject newContainer) {
        this.eStore.setContainer(this, newContainer);
    }

    protected void eBasicSetContainerFeatureID(int newContainerFeatureID) {
        this.eStore.setContainingFeatureID(this, newContainerFeatureID);
    }

    @Override
    public void unsetEContainerSilent() {
        this.eStore().clearEContainerAndEContainingFeatureSilent(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ChronoEObjectLifecycle getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    @Override
    public void setLifecycleStatus(ChronoEObjectLifecycle status) {
        Preconditions.checkNotNull((Object)((Object)status), (Object)"Precondition violation - argument 'status' must not be NULL!");
        this.lifecycleStatus = status;
    }

    @Override
    public boolean exists() {
        return !this.getLifecycleStatus().isRemoved();
    }

    public ChronoEStore eStore() {
        return this.eStore;
    }

    public void eSetStore(InternalEObject.EStore store) {
        this.eStore = (ChronoEStore)store;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChronoEObjectImpl other = (ChronoEObjectImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.eClass().getName() + "@" + this.id);
        return builder.toString();
    }
}

