/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.emf.internal.impl.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.emf.internal.api.ChronoEObjectInternal;
import org.chronos.chronosphere.emf.internal.impl.store.ChronoEStore;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

public abstract class AbstractChronoEStore
implements ChronoEStore {
    protected int preventCascadeUnsetContainer = 0;
    protected int preventCascadeRemoveFromOpposite = 0;

    protected void setEContainerReferenceIfNecessary(InternalEObject object, EStructuralFeature feature, Object value) {
        EReference eReference;
        if (feature instanceof EReference && (eReference = (EReference)feature).isContainment() && value instanceof EObject) {
            EObject child = (EObject)value;
            if (!(child instanceof ChronoEObject)) {
                throw new IllegalArgumentException("Cannot form containment hierarchies between ChronoEObjects and other EObjects!");
            }
            ChronoEObject chronoChild = (ChronoEObject)child;
            int containingFeatureID = 0;
            containingFeatureID = eReference.getEOpposite() != null ? eReference.getEOpposite().getFeatureID() : -1 - feature.getFeatureID();
            chronoChild.eBasicSetContainer(object, containingFeatureID, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetEContainerReferenceIfNecessary(InternalEObject object, EStructuralFeature feature, int index) {
        if (!(feature instanceof EReference)) {
            return;
        }
        EReference eReference = (EReference)feature;
        if (!eReference.isContainment() && !eReference.isContainer()) {
            return;
        }
        if (!this.isSet(object, feature)) {
            return;
        }
        if (this.preventCascadeUnsetContainer > 0) {
            return;
        }
        ++this.preventCascadeUnsetContainer;
        try {
            if (eReference.isContainment()) {
                if (eReference.isMany()) {
                    ArrayList values = Lists.newArrayList((Iterable)((EList)this.get(object, (EStructuralFeature)eReference, -1)));
                    if (index == -1) {
                        for (Object value : values) {
                            ChronoEObjectInternal childEObject = (ChronoEObjectInternal)value;
                            childEObject.unsetEContainerSilent();
                        }
                        return;
                    }
                    ChronoEObjectInternal childEObject = (ChronoEObjectInternal)values.get(index);
                    childEObject.unsetEContainerSilent();
                    return;
                }
                ChronoEObjectInternal childEObject = (ChronoEObjectInternal)this.get(object, (EStructuralFeature)eReference, -1);
                childEObject.unsetEContainerSilent();
                return;
            }
            if (eReference.isContainer()) {
                InternalEObject eContainer = this.getContainer(object);
                EStructuralFeature containingFeature = this.getContainingFeature(object);
                if (containingFeature.isMany()) {
                    List children = (List)eContainer.eGet(containingFeature);
                    children.remove(object);
                    if (children.contains(object)) {
                        throw new RuntimeException("Children still contains the removed object!");
                    }
                } else {
                    eContainer.eSet(containingFeature, null);
                }
                this.clearEContainerAndEContainingFeatureSilent(object);
            }
        }
        finally {
            --this.preventCascadeUnsetContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEOppositeIfNecessary(ChronoEObject object, EStructuralFeature feature, Object otherEnd) {
        Preconditions.checkNotNull((Object)object, (Object)"Precondition violation - argument 'object' must not be NULL!");
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        Preconditions.checkNotNull((Object)otherEnd, (Object)"Precondition violation - argument 'otherEnd' must not be NULL!");
        if (!(feature instanceof EReference)) {
            return;
        }
        EReference reference = (EReference)feature;
        if (reference.getEOpposite() == null) {
            return;
        }
        if (this.preventCascadeRemoveFromOpposite > 0) {
            return;
        }
        ++this.preventCascadeRemoveFromOpposite;
        try {
            EReference oppositeRef = reference.getEOpposite();
            if (reference.isMany()) {
                ArrayList otherEndEObjects = Lists.newArrayList((Iterable)((Collection)otherEnd));
                for (EObject otherEndEObject : otherEndEObjects) {
                    if (oppositeRef.isMany()) {
                        ((List)otherEndEObject.eGet((EStructuralFeature)oppositeRef)).remove(object);
                        continue;
                    }
                    otherEndEObject.eSet((EStructuralFeature)oppositeRef, null);
                }
            } else {
                EObject otherEndEObject = (EObject)otherEnd;
                if (oppositeRef.isMany()) {
                    ((List)otherEndEObject.eGet((EStructuralFeature)oppositeRef)).remove(object);
                } else {
                    otherEndEObject.eSet((EStructuralFeature)oppositeRef, null);
                }
            }
        }
        finally {
            --this.preventCascadeRemoveFromOpposite;
        }
    }
}

