/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.emf.internal.impl.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.emf.internal.api.ChronoEObjectInternal;
import org.chronos.chronosphere.emf.internal.impl.store.AbstractChronoEStore;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.chronos.chronosphere.internal.ogm.api.VertexKind;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

public class ChronoGraphEStore
extends AbstractChronoEStore {
    private final ChronoSphereTransactionInternal owningTransaction;

    public ChronoGraphEStore(ChronoSphereTransactionInternal owningTransaction) {
        Preconditions.checkNotNull((Object)owningTransaction, (Object)"Precondition violation - argument 'owningTransaction' must not be NULL!");
        this.owningTransaction = owningTransaction;
    }

    public Object get(InternalEObject object, EStructuralFeature feature, int index) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        if (feature.isMany()) {
            EList<Object> list = this.getListOfValuesFor(ePackage, vertex, feature);
            if (index == -1) {
                return list;
            }
            return list.get(index);
        }
        return this.getSingleValueFor(ePackage, vertex, feature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object set(InternalEObject object, EStructuralFeature feature, int index, Object value) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        Object result = null;
        if (index == -1) {
            if (feature.isMany()) {
                if (value == null) {
                    if (feature instanceof EAttribute) {
                        EAttribute eAttribute = (EAttribute)feature;
                        ChronoSphereGraphFormat.setEAttributeValues(ePackage, vertex, eAttribute, null);
                    } else {
                        if (!(feature instanceof EReference)) throw ChronoGraphEStore.unknownFeatureTypeException(feature);
                        EReference eReference = (EReference)feature;
                        ChronoSphereGraphFormat.setEReferenceTargets(ePackage, vertex, eReference, null);
                    }
                } else if (feature instanceof EAttribute) {
                    EAttribute eAttribute = (EAttribute)feature;
                    ChronoSphereGraphFormat.setEAttributeValues(ePackage, vertex, eAttribute, (Collection)value);
                } else {
                    if (!(feature instanceof EReference)) throw ChronoGraphEStore.unknownFeatureTypeException(feature);
                    EReference eReference = (EReference)feature;
                    ArrayList targetVertices = Lists.newArrayList();
                    Collection targetEObjects = (Collection)value;
                    for (EObject targetEObject : targetEObjects) {
                        targetVertices.add(this.getEObjectVertex((ChronoEObject)targetEObject));
                    }
                    ChronoSphereGraphFormat.setEReferenceTargets(ePackage, vertex, eReference, targetVertices);
                }
            } else if (value == null) {
                if (feature instanceof EAttribute) {
                    EAttribute eAttribute = (EAttribute)feature;
                    ChronoSphereGraphFormat.setEAttributeValue(ePackage, vertex, eAttribute, null);
                } else {
                    if (!(feature instanceof EReference)) throw ChronoGraphEStore.unknownFeatureTypeException(feature);
                    EReference eReference = (EReference)feature;
                    ChronoSphereGraphFormat.setEReferenceTarget(ePackage, vertex, eReference, null);
                }
            } else if (feature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)feature;
                ChronoSphereGraphFormat.setEAttributeValue(ePackage, vertex, eAttribute, value);
            } else {
                if (!(feature instanceof EReference)) throw ChronoGraphEStore.unknownFeatureTypeException(feature);
                EReference eReference = (EReference)feature;
                Vertex targetVertex = this.getEObjectVertex((ChronoEObject)value);
                ChronoSphereGraphFormat.setEReferenceTarget(ePackage, vertex, eReference, targetVertex);
            }
        } else {
            EList<Object> list = this.getListOfValuesFor(ePackage, vertex, feature);
            result = list.set(index, value);
            this.writeListOfValuesToGraph(ePackage, vertex, feature, (List<Object>)list);
        }
        this.setEContainerReferenceIfNecessary(object, feature, value);
        return result;
    }

    public boolean isSet(InternalEObject object, EStructuralFeature feature) {
        EReference eReference;
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        if (feature instanceof EReference && (eReference = (EReference)feature).isContainer()) {
            return this.getContainer(object) != null;
        }
        if (feature.isMany()) {
            return !this.getListOfValuesFor(ePackage, vertex, feature).isEmpty();
        }
        if (feature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)feature;
            return ChronoSphereGraphFormat.getEAttributeValue(ePackage, vertex, eAttribute) != null;
        }
        if (feature instanceof EReference) {
            eReference = (EReference)feature;
            return ChronoSphereGraphFormat.getEReferenceTarget(ePackage, vertex, eReference) != null;
        }
        throw ChronoGraphEStore.unknownFeatureTypeException(feature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unset(InternalEObject object, EStructuralFeature feature) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        if (!this.isSet(object, feature)) {
            return;
        }
        Object oldValue = object.eGet(feature);
        this.unsetEContainerReferenceIfNecessary(eObject, feature, -1);
        this.removeFromEOppositeIfNecessary(eObject, feature, oldValue);
        if (!feature.isMany()) {
            if (feature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)feature;
                ChronoSphereGraphFormat.setEAttributeValue(ePackage, vertex, eAttribute, null);
                return;
            } else {
                if (!(feature instanceof EReference)) throw ChronoGraphEStore.unknownFeatureTypeException(feature);
                EReference eReference = (EReference)feature;
                ChronoSphereGraphFormat.setEReferenceTarget(ePackage, vertex, eReference, null);
            }
            return;
        } else {
            this.writeListOfValuesToGraph(ePackage, vertex, feature, null);
        }
    }

    public boolean isEmpty(InternalEObject object, EStructuralFeature feature) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        return this.getListOfValuesFor(ePackage, vertex, feature).isEmpty();
    }

    public int size(InternalEObject object, EStructuralFeature feature) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        return this.getListOfValuesFor(ePackage, vertex, feature).size();
    }

    public boolean contains(InternalEObject object, EStructuralFeature feature, Object value) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        return this.getListOfValuesFor(ePackage, vertex, feature).contains(value);
    }

    public int indexOf(InternalEObject object, EStructuralFeature feature, Object value) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        return this.getListOfValuesFor(ePackage, vertex, feature).indexOf(value);
    }

    public int lastIndexOf(InternalEObject object, EStructuralFeature feature, Object value) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        return this.getListOfValuesFor(ePackage, vertex, feature).lastIndexOf(value);
    }

    public void add(InternalEObject object, EStructuralFeature feature, int index, Object value) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        EList<Object> list = this.getListOfValuesFor(ePackage, vertex, feature);
        list.add(index, value);
        this.writeListOfValuesToGraph(ePackage, vertex, feature, (List<Object>)list);
    }

    public Object remove(InternalEObject object, EStructuralFeature feature, int index) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            Object child = this.get(object, feature, index);
            this.unsetEContainerReferenceIfNecessary(eObject, feature, index);
            EList<Object> values = this.getListOfValuesFor(ePackage, vertex, feature);
            values.remove(child);
            this.writeListOfValuesToGraph(ePackage, vertex, feature, (List<Object>)values);
            return child;
        }
        EList<Object> list = this.getListOfValuesFor(ePackage, vertex, feature);
        Object result = list.remove(index);
        this.writeListOfValuesToGraph(ePackage, vertex, feature, (List<Object>)list);
        return result;
    }

    public Object move(InternalEObject object, EStructuralFeature feature, int targetIndex, int sourceIndex) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        EList<Object> values = this.getListOfValuesFor(ePackage, vertex, feature);
        Object result = values.move(targetIndex, sourceIndex);
        this.writeListOfValuesToGraph(ePackage, vertex, feature, (List<Object>)values);
        return result;
    }

    public void clear(InternalEObject object, EStructuralFeature feature) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        if (!this.isSet(object, feature)) {
            return;
        }
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        this.unsetEContainerReferenceIfNecessary(eObject, feature, -1);
        this.writeListOfValuesToGraph(ePackage, vertex, feature, null);
    }

    public Object[] toArray(InternalEObject object, EStructuralFeature feature) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        return this.getListOfValuesFor(ePackage, vertex, feature).toArray();
    }

    public <T> T[] toArray(InternalEObject object, EStructuralFeature feature, T[] array) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        return this.getListOfValuesFor(ePackage, vertex, feature).toArray((Object[])array);
    }

    public int hashCode(InternalEObject object, EStructuralFeature feature) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        if (!this.isSet(object, feature)) {
            return 0;
        }
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        if (feature.isMany()) {
            return this.getListOfValuesFor(ePackage, vertex, feature).hashCode();
        }
        Object singleValue = this.getSingleValueFor(ePackage, vertex, feature);
        if (singleValue == null) {
            return 0;
        }
        return singleValue.hashCode();
    }

    @Override
    public void setContainer(InternalEObject object, InternalEObject newContainer) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        if (newContainer != null) {
            Vertex targetVertex = this.getEObjectVertex(this.assertIsChronoEObject((EObject)newContainer));
            ChronoSphereGraphFormat.setEContainer(vertex, targetVertex);
        } else {
            ChronoSphereGraphFormat.setEContainer(vertex, null);
        }
    }

    @Override
    public void setContainingFeatureID(InternalEObject object, int newContainerFeatureID) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoSphereGraphFormat.setEContainingFeatureId(vertex, newContainerFeatureID);
    }

    public InternalEObject getContainer(InternalEObject object) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        if (vertex == null) {
            return null;
        }
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        Vertex eContainerVertex = ChronoSphereGraphFormat.getEContainer(vertex);
        if (eContainerVertex == null) {
            return null;
        }
        return this.createEObjectForVertex(ePackage, eContainerVertex);
    }

    public EStructuralFeature getContainingFeature(InternalEObject object) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        Integer eContainingFeatureID = ChronoSphereGraphFormat.getEContainingFeatureId(vertex);
        if (eContainingFeatureID == null) {
            return null;
        }
        ChronoEObjectInternal eContainer = (ChronoEObjectInternal)this.getContainer(eObject);
        EReference containingFeature = null;
        if (eContainingFeatureID < 0) {
            return eContainer.eClass().getEStructuralFeature(-1 - eContainingFeatureID);
        }
        containingFeature = ((EReference)object.eClass().getEStructuralFeature(eContainingFeatureID.intValue())).getEOpposite();
        if (containingFeature == null) {
            throw new IllegalStateException("Could not resolve Feature ID '" + eContainingFeatureID + "' in eContainer '" + eContainer + "' (EClass: '" + eContainer.eClass().getName() + "')!");
        }
        return containingFeature;
    }

    @Override
    public int getContainingFeatureID(InternalEObject object) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        Integer eContainingFeatureID = ChronoSphereGraphFormat.getEContainingFeatureId(vertex);
        if (eContainingFeatureID == null) {
            return 0;
        }
        return eContainingFeatureID;
    }

    public EObject create(EClass eClass) {
        this.assertTxOpen();
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        EPackage ePackage = eClass.getEPackage();
        while (ePackage.getESuperPackage() != null) {
            ePackage = ePackage.getESuperPackage();
        }
        ChronoEPackageRegistry cep = this.owningTransaction.getEPackageRegistry();
        Vertex vertex = this.getGraph().addVertex(new Object[]{T.id, UUID.randomUUID()});
        ChronoSphereGraphFormat.setVertexKind(vertex, VertexKind.EOBJECT);
        ChronoSphereGraphFormat.setEClassForEObjectVertex(cep, vertex, eClass);
        return this.createEObjectForVertex(cep, vertex);
    }

    @Override
    public void clearEContainerAndEContainingFeatureSilent(InternalEObject object) {
        this.assertTxOpen();
        ChronoEObjectInternal eObject = this.assertIsChronoEObject((EObject)object);
        Vertex vertex = this.getEObjectVertex(eObject);
        ChronoSphereGraphFormat.setEContainer(vertex, null);
        ChronoSphereGraphFormat.setEContainingFeatureId(vertex, null);
    }

    public void deepMerge(Collection<ChronoEObjectInternal> mergeObjects) {
        this.deepMerge(mergeObjects, null, false, 0);
    }

    public void deepMergeIncremental(Collection<ChronoEObjectInternal> mergeObjects, ChronoSphereTransaction tx, int batchSize) {
        Preconditions.checkNotNull(mergeObjects, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkNotNull((Object)tx, (Object)"Precondition violation - argument 'tx' must not be NULL!");
        Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'batchSize' must be greater than zero!");
        this.deepMerge(mergeObjects, tx, true, batchSize);
    }

    public void deepDelete(Collection<ChronoEObjectInternal> eObjectsToDelete, boolean cascadeDeletionToEContents) {
        Preconditions.checkNotNull(eObjectsToDelete, (Object)"Precondition violation - argument 'eObjectsToDelete' must not be NULL!");
        this.deepDelete(eObjectsToDelete, null, false, 0, cascadeDeletionToEContents);
    }

    public void deepDelete(Collection<ChronoEObjectInternal> eObjectsToDelete, ChronoSphereTransaction tx, int batchSize, boolean cascadeDeletionToEContents) {
        this.deepDelete(eObjectsToDelete, tx, true, batchSize, cascadeDeletionToEContents);
    }

    private void deepMerge(Collection<ChronoEObjectInternal> mergeObjects, ChronoSphereTransaction tx, boolean useIncrementalCommits, int batchSize) {
        HashSet objectsToMerge = Sets.newHashSet();
        for (ChronoEObjectInternal eObject : mergeObjects) {
            TreeIterator contents = eObject.eAllContents();
            objectsToMerge.add(eObject);
            while (contents.hasNext()) {
                objectsToMerge.add((ChronoEObjectInternal)contents.next());
            }
        }
        int currentBatchSize = 0;
        for (ChronoEObjectInternal currentEObject : objectsToMerge) {
            this.mergeObjectAndAttributes(currentEObject);
            if (!useIncrementalCommits || ++currentBatchSize < batchSize) continue;
            tx.commitIncremental();
            currentBatchSize = 0;
        }
        for (ChronoEObjectInternal currentEObject : objectsToMerge) {
            this.mergeEReferencesAndEContainer(currentEObject);
            if (!useIncrementalCommits || ++currentBatchSize < batchSize) continue;
            tx.commitIncremental();
            currentBatchSize = 0;
        }
        for (ChronoEObjectInternal currentEObject : objectsToMerge) {
            currentEObject.eSetStore(this);
            if (!useIncrementalCommits || ++currentBatchSize < batchSize) continue;
            tx.commitIncremental();
            currentBatchSize = 0;
        }
    }

    private void mergeObjectAndAttributes(ChronoEObjectInternal eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        if (eObject.isAttached()) {
            return;
        }
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        Vertex vertex = this.createVertexForEObject(eObject);
        for (EAttribute eAttribute : eObject.eClass().getEAllAttributes()) {
            if (!eObject.eIsSet((EStructuralFeature)eAttribute)) continue;
            Object value = eObject.eGet((EStructuralFeature)eAttribute);
            if (eAttribute.isMany()) {
                ChronoSphereGraphFormat.setEAttributeValues(ePackage, vertex, eAttribute, (Collection)value);
                continue;
            }
            ChronoSphereGraphFormat.setEAttributeValue(ePackage, vertex, eAttribute, value);
        }
    }

    private void mergeEReferencesAndEContainer(ChronoEObjectInternal eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        if (eObject.isAttached()) {
            return;
        }
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        Vertex vertex = (Vertex)Iterators.getOnlyElement((Iterator)this.getGraph().vertices(new Object[]{eObject.getId()}));
        ChronoEObjectInternal eContainer = (ChronoEObjectInternal)eObject.eContainer();
        if (eContainer != null) {
            Vertex eContainerVertex = this.getEObjectVertex(eContainer);
            ChronoSphereGraphFormat.setEContainer(vertex, eContainerVertex);
            EStructuralFeature eContainingFeature = eObject.eContainingFeature();
            if (eContainingFeature != null) {
                int containingFeatureID = -1;
                containingFeatureID = eObject.eClass().getFeatureID(eContainingFeature) >= 0 ? eObject.eClass().getFeatureID(eContainingFeature) : -1 - eContainingFeature.getFeatureID();
                ChronoSphereGraphFormat.setEContainingFeatureId(vertex, containingFeatureID);
            }
        }
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            if (!eObject.eIsSet((EStructuralFeature)eReference)) continue;
            Object value = eObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List targets = (List)value;
                List<Vertex> targetVertices = targets.stream().map(obj -> this.getEObjectVertex((ChronoEObject)obj)).filter(obj -> obj != null).collect(Collectors.toList());
                ChronoSphereGraphFormat.setEReferenceTargets(ePackage, vertex, eReference, targetVertices);
                continue;
            }
            ChronoEObjectInternal target = (ChronoEObjectInternal)value;
            Vertex targetVertex = this.getEObjectVertex(target);
            if (targetVertex == null) continue;
            ChronoSphereGraphFormat.setEReferenceTarget(ePackage, vertex, eReference, targetVertex);
        }
    }

    private Vertex createVertexForEObject(ChronoEObjectInternal eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        ChronoEPackageRegistry ePackage = this.getEPackageRegistry();
        Vertex vertex = this.getGraph().addVertex(new Object[]{T.id, eObject.getId()});
        ChronoSphereGraphFormat.setVertexKind(vertex, VertexKind.EOBJECT);
        ChronoSphereGraphFormat.setEClassForEObjectVertex(ePackage, vertex, eObject.eClass());
        return vertex;
    }

    private void assertTxOpen() {
        if (this.owningTransaction.isClosed()) {
            throw new IllegalStateException("ChronoSphereTransaction has already been closed!");
        }
    }

    private ChronoGraph getGraph() {
        return this.owningTransaction.getGraph();
    }

    private ChronoEObjectInternal assertIsChronoEObject(EObject eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkArgument((boolean)(eObject instanceof ChronoEObject), (Object)"Precondition violation - argument 'eObject' is no ChronoEObject! Did you use the correct EFactory in your EPackage?");
        return (ChronoEObjectInternal)eObject;
    }

    private Vertex getEObjectVertex(ChronoEObject object) {
        String id = object.getId();
        Iterator iterator = this.getGraph().vertices(new Object[]{id});
        return (Vertex)Iterators.getOnlyElement((Iterator)iterator, null);
    }

    private ChronoEPackageRegistry getEPackageRegistry() {
        return this.owningTransaction.getEPackageRegistry();
    }

    private ChronoEObjectInternal createEObjectForVertex(ChronoEPackageRegistry cep, Vertex vertex) {
        return (ChronoEObjectInternal)this.owningTransaction.getEObjectById((String)vertex.id());
    }

    private EList<Object> getListOfValuesFor(ChronoEPackageRegistry cep, Vertex vertex, EStructuralFeature feature) {
        Preconditions.checkNotNull((Object)cep, (Object)"Precondition violation - argument 'cep' must not be NULL!");
        Preconditions.checkNotNull((Object)vertex, (Object)"Precondition violation - argument 'vertex' must not be NULL!");
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        BasicEList eList = new BasicEList();
        if (feature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)feature;
            eList.addAll(ChronoSphereGraphFormat.getEAttributeValues(cep, vertex, eAttribute));
            return eList;
        }
        if (feature instanceof EReference) {
            EReference eReference = (EReference)feature;
            List<Vertex> vertices = ChronoSphereGraphFormat.getEReferenceTargets(cep, vertex, eReference);
            for (Vertex eObjectVertex : vertices) {
                ChronoEObjectInternal eObjectForVertex = this.createEObjectForVertex(cep, eObjectVertex);
                eList.add((Object)eObjectForVertex);
            }
            return eList;
        }
        throw ChronoGraphEStore.unknownFeatureTypeException(feature);
    }

    private Object getSingleValueFor(ChronoEPackageRegistry ePackage, Vertex vertex, EStructuralFeature feature) {
        if (feature instanceof EAttribute) {
            EAttribute attribute = (EAttribute)feature;
            return ChronoSphereGraphFormat.getEAttributeValue(ePackage, vertex, attribute);
        }
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            Vertex targetVertex = ChronoSphereGraphFormat.getEReferenceTarget(ePackage, vertex, reference);
            if (targetVertex == null) {
                return null;
            }
            return this.createEObjectForVertex(ePackage, targetVertex);
        }
        throw ChronoGraphEStore.unknownFeatureTypeException(feature);
    }

    private static RuntimeException unknownFeatureTypeException(EStructuralFeature feature) {
        String className = feature.getClass().getName();
        return new RuntimeException("Encountered unknown subclass of EStructuralFeature: '" + className + "'!");
    }

    private void writeListOfValuesToGraph(ChronoEPackageRegistry ePackage, Vertex vertex, EStructuralFeature feature, List<Object> list) {
        if (feature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)feature;
            ChronoSphereGraphFormat.setEAttributeValues(ePackage, vertex, eAttribute, Lists.newArrayList(list));
        } else if (feature instanceof EReference) {
            EReference eReference = (EReference)feature;
            if (list == null || list.isEmpty()) {
                ChronoSphereGraphFormat.setEReferenceTargets(ePackage, vertex, eReference, null);
            } else {
                ArrayList targetVertices = Lists.newArrayList();
                for (Object target : list) {
                    EObject targetEObject = (EObject)target;
                    targetVertices.add(this.getEObjectVertex((ChronoEObject)targetEObject));
                }
                ChronoSphereGraphFormat.setEReferenceTargets(ePackage, vertex, eReference, targetVertices);
            }
        } else {
            throw ChronoGraphEStore.unknownFeatureTypeException(feature);
        }
    }

    private void deepDelete(Collection<ChronoEObjectInternal> eObjectsToDelete, ChronoSphereTransaction tx, boolean useIncrementalCommits, int batchSize, boolean cascadeDeletionToEContents) {
        HashSet allEObjectsToDelete = Sets.newHashSet();
        if (cascadeDeletionToEContents) {
            for (ChronoEObjectInternal eObject : eObjectsToDelete) {
                TreeIterator contents = eObject.eAllContents();
                allEObjectsToDelete.add(eObject);
                while (contents.hasNext()) {
                    allEObjectsToDelete.add((ChronoEObjectInternal)contents.next());
                }
            }
        } else {
            allEObjectsToDelete.addAll(eObjectsToDelete);
        }
        int currentBatchSize = 0;
        for (ChronoEObjectInternal currentEObject : allEObjectsToDelete) {
            Vertex vertex = ChronoSphereGraphFormat.getVertexForEObject(this.getGraph(), currentEObject);
            if (vertex == null) continue;
            vertex.remove();
            if (!useIncrementalCommits || ++currentBatchSize < batchSize) continue;
            tx.commitIncremental();
            currentBatchSize = 0;
        }
    }
}

