/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.emf.internal.impl.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.chronos.chronosphere.emf.impl.ChronoEObjectImpl;
import org.chronos.chronosphere.emf.internal.api.ChronoEObjectInternal;
import org.chronos.chronosphere.emf.internal.impl.store.AbstractChronoEStore;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

public class OwnedTransientEStore
extends AbstractChronoEStore {
    private ChronoEObjectInternal owner;
    private final Map<EStructuralFeature, Object> contents = Maps.newHashMap();
    private ChronoEObjectInternal eContainer;
    private Integer eContainingFeatureID;

    public OwnedTransientEStore(ChronoEObjectInternal owner) {
        Preconditions.checkNotNull((Object)owner, (Object)"Precondition violation - argument 'owner' must not be NULL!");
        this.owner = owner;
    }

    public Object get(InternalEObject object, EStructuralFeature feature, int index) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        if (feature.isMany()) {
            EList<Object> list = this.getListOfValuesFor(feature);
            if (index == -1) {
                return list;
            }
            return list.get(index);
        }
        return this.contents.get(feature);
    }

    public Object set(InternalEObject object, EStructuralFeature feature, int index, Object value) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        Object result = null;
        if (index == -1) {
            result = value == null ? this.contents.remove(feature) : this.contents.put(feature, value);
        } else {
            EList<Object> list = this.getListOfValuesFor(feature);
            result = list.set(index, value);
        }
        this.setEContainerReferenceIfNecessary(object, feature, value);
        return result;
    }

    public boolean isSet(InternalEObject object, EStructuralFeature feature) {
        EReference eReference;
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        if (feature instanceof EReference && (eReference = (EReference)feature).isContainer()) {
            return this.getContainer(object) != null;
        }
        if (feature.isMany()) {
            return !this.getListOfValuesFor(feature).isEmpty();
        }
        return this.contents.containsKey(feature);
    }

    public void unset(InternalEObject object, EStructuralFeature feature) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        if (!this.isSet(object, feature)) {
            return;
        }
        Object oldValue = object.eGet(feature);
        this.unsetEContainerReferenceIfNecessary(this.owner, feature, -1);
        this.removeFromEOppositeIfNecessary(this.owner, feature, oldValue);
        this.contents.remove(feature);
    }

    public boolean isEmpty(InternalEObject object, EStructuralFeature feature) {
        this.assertIsOwner((EObject)object);
        return this.getListOfValuesFor(feature).isEmpty();
    }

    public int size(InternalEObject object, EStructuralFeature feature) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        return this.getListOfValuesFor(feature).size();
    }

    public boolean contains(InternalEObject object, EStructuralFeature feature, Object value) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        return this.getListOfValuesFor(feature).contains(value);
    }

    public int indexOf(InternalEObject object, EStructuralFeature feature, Object value) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        return this.getListOfValuesFor(feature).indexOf(value);
    }

    public int lastIndexOf(InternalEObject object, EStructuralFeature feature, Object value) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)value, (Object)"Precondition violation - argument 'value' must not be NULL!");
        return this.getListOfValuesFor(feature).lastIndexOf(value);
    }

    public void add(InternalEObject object, EStructuralFeature feature, int index, Object value) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        this.getListOfValuesFor(feature).add(index, value);
    }

    public Object remove(InternalEObject object, EStructuralFeature feature, int index) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            Object child = this.get(object, feature, index);
            this.unsetEContainerReferenceIfNecessary(this.owner, feature, index);
            this.getListOfValuesFor(feature).remove(child);
            return child;
        }
        return this.getListOfValuesFor(feature).remove(index);
    }

    public Object move(InternalEObject object, EStructuralFeature feature, int targetIndex, int sourceIndex) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        return this.getListOfValuesFor(feature).move(targetIndex, sourceIndex);
    }

    public void clear(InternalEObject object, EStructuralFeature feature) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        if (!this.isSet(object, feature)) {
            return;
        }
        this.unsetEContainerReferenceIfNecessary(this.owner, feature, -1);
        this.contents.remove(feature);
    }

    public Object[] toArray(InternalEObject object, EStructuralFeature feature) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        return this.getListOfValuesFor(feature).toArray();
    }

    public <T> T[] toArray(InternalEObject object, EStructuralFeature feature, T[] array) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        return this.getListOfValuesFor(feature).toArray((Object[])array);
    }

    public int hashCode(InternalEObject object, EStructuralFeature feature) {
        this.assertIsOwner((EObject)object);
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        if (!this.isSet(object, feature)) {
            return 0;
        }
        if (feature.isMany()) {
            return this.getListOfValuesFor(feature).hashCode();
        }
        return this.contents.get(feature).hashCode();
    }

    @Override
    public void setContainer(InternalEObject object, InternalEObject newContainer) {
        this.assertIsOwner((EObject)object);
        this.eContainer = (ChronoEObjectInternal)newContainer;
    }

    @Override
    public void setContainingFeatureID(InternalEObject object, int newContainerFeatureID) {
        this.assertIsOwner((EObject)object);
        this.eContainingFeatureID = newContainerFeatureID;
    }

    public InternalEObject getContainer(InternalEObject object) {
        this.assertIsOwner((EObject)object);
        return this.eContainer;
    }

    public EStructuralFeature getContainingFeature(InternalEObject object) {
        this.assertIsOwner((EObject)object);
        if (this.eContainingFeatureID == null) {
            return null;
        }
        EReference containingFeature = null;
        if (this.eContainingFeatureID <= -1) {
            return this.eContainer.eClass().getEStructuralFeature(-1 - this.eContainingFeatureID);
        }
        containingFeature = ((EReference)object.eClass().getEStructuralFeature(this.eContainingFeatureID.intValue())).getEOpposite();
        if (this.eContainingFeatureID != null && containingFeature == null) {
            throw new IllegalStateException("Could not resolve Feature ID '" + this.eContainingFeatureID + "' in eContainer '" + this.eContainer + "' (EClass: '" + this.eContainer.eClass().getName() + "')!");
        }
        return containingFeature;
    }

    @Override
    public int getContainingFeatureID(InternalEObject eObject) {
        this.assertIsOwner((EObject)eObject);
        if (this.eContainingFeatureID == null) {
            return 0;
        }
        return this.eContainingFeatureID;
    }

    public EObject create(EClass eClass) {
        ChronoEObjectImpl eObject = new ChronoEObjectImpl();
        eObject.eSetClass(eClass);
        return eObject;
    }

    @Override
    public void clearEContainerAndEContainingFeatureSilent(InternalEObject eObject) {
        this.assertIsOwner((EObject)eObject);
        this.eContainer = null;
        this.eContainingFeatureID = null;
    }

    public ChronoEObjectInternal getOwner() {
        return this.owner;
    }

    private EList<Object> getListOfValuesFor(EStructuralFeature feature) {
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        Preconditions.checkArgument((boolean)feature.isMany(), (Object)"Precondition violation - argument 'feature' is multiplicity-one, can't get list value!");
        EList result = (EList)this.contents.get(feature);
        if (result == null) {
            result = new BasicEList();
            this.contents.put(feature, result);
        }
        return result;
    }

    private void assertIsOwner(EObject eObject) {
        if (eObject == null) {
            throw new NullPointerException("OwnedTransientEStore can not work with EObject NULL!");
        }
        if (this.owner != eObject) {
            throw new IllegalArgumentException("OwnedTransientEStore can only work with the owning EObject!");
        }
    }
}

