/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.emf.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.chronos.chronosphere.api.exceptions.EPackagesAreNotSelfContainedException;
import org.chronos.chronosphere.api.exceptions.emf.NameResolutionException;
import org.chronos.chronosphere.api.exceptions.emf.XMIConversionFailedException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class EMFUtils {
    public static final String PACKAGE_PATH_SEPARATOR = "::";
    public static final String CLASS_FEATURE_SEPARATOR = "#";

    public static ResourceSet createResourceSet() {
        return EMFUtils.createResourceSet(Collections.emptySet());
    }

    public static ResourceSet createResourceSet(Set<EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        for (EPackage ePackage : ePackages) {
            resSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
        return resSet;
    }

    public static Resource createTemporaryResource(String name, EObject ... contents) {
        return EMFUtils.createTemporaryResource(name, Collections.emptySet(), contents);
    }

    public static Resource createTemporaryResource(String name, Set<EPackage> ePackages, EObject ... contents) {
        Preconditions.checkNotNull((Object)name, (Object)"Precondition violation - argument 'name' must not be NULL!");
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        ResourceSet resSet = EMFUtils.createResourceSet(ePackages);
        return EMFUtils.createTemporaryResource(resSet, name, contents);
    }

    public static Resource createTemporaryResource(ResourceSet set, String name, EObject ... contents) {
        Resource res = set.createResource(URI.createPlatformResourceURI((String)("TEMP/" + name), (boolean)false));
        for (EObject obj : contents) {
            res.getContents().add((Object)obj);
        }
        return res;
    }

    public static String writeEPackageToXMI(EPackage ePackage) {
        Preconditions.checkNotNull((Object)ePackage, (Object)"Precondition violation - argument 'ePackage' must not be NULL!");
        return EMFUtils.writeEPackagesToXMI(Collections.singleton(ePackage));
    }

    public static String writeEPackagesToXMI(Iterable<? extends EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        try {
            return EMFUtils.writeEObjectsToXMI(ePackages);
        }
        catch (XMIConversionFailedException e) {
            throw new XMIConversionFailedException("Could not convert EPackages to XMI!", (Throwable)((Object)e));
        }
    }

    public static EPackage readEPackageFromXMI(String xmiContents) {
        Preconditions.checkNotNull((Object)xmiContents, (Object)"Precondition violation - argument 'xmiContents' must not be NULL!");
        try {
            List<EObject> eObjects = EMFUtils.readEObjectsFromXMI(xmiContents);
            if (eObjects == null || eObjects.isEmpty()) {
                return null;
            }
            EObject singleObject = (EObject)Iterables.getOnlyElement(eObjects);
            if (!(singleObject instanceof EPackage)) {
                throw new IllegalStateException("Attempted to read EPackage from XMI, but encountered EObject with EClass '" + singleObject.eClass().getName() + "'!");
            }
            return (EPackage)singleObject;
        }
        catch (XMIConversionFailedException e) {
            throw new XMIConversionFailedException("Could not read EPackage from XMI data!", (Throwable)((Object)e));
        }
    }

    public static List<EPackage> readEPackagesFromXMI(String xmiContents) {
        Preconditions.checkNotNull((Object)xmiContents, (Object)"Precondition violation - argument 'xmiContents' must not be NULL!");
        try {
            List<EObject> eObjects = EMFUtils.readEObjectsFromXMI(xmiContents);
            if (eObjects == null || eObjects.isEmpty()) {
                return null;
            }
            ArrayList ePackages = Lists.newArrayList();
            eObjects.forEach(eObject -> {
                if (!(eObject instanceof EPackage)) {
                    throw new IllegalStateException("Attempted to read EPackage from XMI, but encountered EObject with EClass '" + eObject.eClass().getName() + "'!");
                }
                ePackages.add((EPackage)eObject);
            });
            return ePackages;
        }
        catch (XMIConversionFailedException e) {
            throw new XMIConversionFailedException("Could not read EPackage from XMI data!", (Throwable)((Object)e));
        }
    }

    public static String writeEObjectToXMI(EObject eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        return EMFUtils.writeEObjectsToXMI(Collections.singleton(eObject));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String writeEObjectsToXMI(Iterable<? extends EObject> eObjects) {
        Preconditions.checkNotNull(eObjects, (Object)"Precondition violation - argument 'eObjects' must not be NULL!");
        EObject[] eObjectArray = (EObject[])Iterables.toArray(eObjects, EObject.class);
        Resource resource = EMFUtils.createTemporaryResource("temp.xmi", eObjectArray);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String xmi;
            resource.save((OutputStream)baos, null);
            String string = xmi = baos.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new XMIConversionFailedException("Could not convert EObject to XMI!", ioe);
        }
    }

    public static List<EObject> readEObjectsFromXMI(String xmiContents) {
        Preconditions.checkNotNull((Object)xmiContents, (Object)"Precondition violation - argument 'xmiContents' must not be NULL!");
        return EMFUtils.readEObjectsFromXMI(xmiContents, Collections.emptySet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<EObject> readEObjectsFromXMI(String xmiContents, Set<EPackage> ePackages) {
        Preconditions.checkNotNull((Object)xmiContents, (Object)"Precondition violation - argument 'xmiContents' must not be NULL!");
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Resource resource = EMFUtils.createTemporaryResource("temp.xmi", ePackages, new EObject[0]);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xmiContents.getBytes());){
            resource.load((InputStream)bais, null);
            EList eList = resource.getContents();
            return eList;
        }
        catch (IOException ioe) {
            throw new XMIConversionFailedException("Could not read EObject(s) from XMI data!", ioe);
        }
    }

    public static boolean isXMIFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        return file.getName().endsWith(".xmi");
    }

    public static void assertIsXMIFile(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"Precondition violation - argument 'file' must not be NULL!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"Precondition violation - the given XMI File does not exist!");
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"Precondition violation - the given XMI File is a directory, not a file!");
        Preconditions.checkArgument((boolean)file.getName().endsWith(".xmi"), (Object)"Precondition violation - the given file does not end with '*.xmi'!");
    }

    public static EList<EObject> eGetMany(EObject eObject, EReference eReference) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        Preconditions.checkArgument((boolean)eReference.isMany(), (Object)"Precondition violation - argument 'eReference' must be multiplicity-many!");
        EList list = (EList)eObject.eGet((EStructuralFeature)eReference);
        return list;
    }

    public static Set<EReference> getEReferencesWithNonContainedEReferenceTypes(Iterable<? extends EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Set<EPackage> allEPackages = EMFUtils.flattenEPackages(ePackages);
        HashSet containedEPackages = Sets.newHashSet(allEPackages);
        containedEPackages.addAll(EMFUtils.flattenEPackage((EPackage)EcorePackage.eINSTANCE));
        HashSet resultSet = Sets.newHashSet();
        for (EPackage ePackage : allEPackages) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                for (EReference eReference : eClass.getEAllReferences()) {
                    EClass eReferenceType = eReference.getEReferenceType();
                    EPackage owningEPackage = eReferenceType.getEPackage();
                    if (containedEPackages.contains(owningEPackage)) continue;
                    resultSet.add(eReference);
                }
            }
        }
        return resultSet;
    }

    public static boolean areEPackagesSelfContained(Iterable<? extends EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Set<EReference> nonContainedReferences = EMFUtils.getEReferencesWithNonContainedEReferenceTypes(ePackages);
        return nonContainedReferences.isEmpty();
    }

    public static void assertEPackagesAreSelfContained(Iterable<? extends EPackage> ePackages) throws EPackagesAreNotSelfContainedException {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Set<EReference> nonContainedReferences = EMFUtils.getEReferencesWithNonContainedEReferenceTypes(ePackages);
        if (nonContainedReferences.isEmpty()) {
            return;
        }
        throw new EPackagesAreNotSelfContainedException(nonContainedReferences);
    }

    public static Set<EPackage> flattenEPackage(EPackage ePackage) {
        Preconditions.checkNotNull((Object)ePackage, (Object)"Precondition violation - argument 'ePackage' must not be NULL!");
        return EMFUtils.flattenEPackages(Collections.singleton(ePackage));
    }

    public static Set<EPackage> flattenEPackages(Iterable<? extends EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        HashSet flattenedEPackages = Sets.newHashSet();
        for (EPackage ePackage : ePackages) {
            flattenedEPackages.add(ePackage);
            TreeIterator eAllContents = ePackage.eAllContents();
            eAllContents.forEachRemaining(eObject -> {
                if (eObject instanceof EPackage) {
                    flattenedEPackages.add((EPackage)eObject);
                }
            });
        }
        return flattenedEPackages;
    }

    public static Set<EPackage> flattenEPackages(Iterator<? extends EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        HashSet flattenedEPackages = Sets.newHashSet();
        while (ePackages.hasNext()) {
            EPackage rootEPackage = ePackages.next();
            flattenedEPackages.add(rootEPackage);
            TreeIterator eAllContents = rootEPackage.eAllContents();
            eAllContents.forEachRemaining(eObject -> {
                if (eObject instanceof EPackage) {
                    flattenedEPackages.add((EPackage)eObject);
                }
            });
        }
        return flattenedEPackages;
    }

    public static EReference getEReference(EClass eClass, String name) {
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        Preconditions.checkNotNull((Object)name, (Object)"Precondition violation - argument 'name' must not be NULL!");
        return eClass.getEAllReferences().stream().filter(eRef -> eRef.getName().equals(name)).findFirst().orElse(null);
    }

    public static EAttribute getEAttribute(EClass eClass, String name) {
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        Preconditions.checkNotNull((Object)name, (Object)"Precondition violation - argument 'name' must not be NULL!");
        return eClass.getEAllAttributes().stream().filter(eAttr -> eAttr.getName().equals(name)).findFirst().orElse(null);
    }

    public static String fullyQualifiedNameFor(EStructuralFeature feature) {
        Preconditions.checkNotNull((Object)feature, (Object)"Precondition violation - argument 'feature' must not be NULL!");
        String eClassName = EMFUtils.fullyQualifiedNameFor(feature.getEContainingClass());
        return eClassName + CLASS_FEATURE_SEPARATOR + feature.getName();
    }

    public static String fullyQualifiedNameFor(EClass eClass) {
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        String ePackageQualifiedName = EMFUtils.fullyQualifiedNameFor(eClass.getEPackage());
        return ePackageQualifiedName + PACKAGE_PATH_SEPARATOR + eClass.getName();
    }

    public static String fullyQualifiedNameFor(EClassifier eClassifier) {
        Preconditions.checkNotNull((Object)eClassifier, (Object)"Precondition violation - argument 'eClassifier' must not be NULL!");
        String ePackageQualifiedName = EMFUtils.fullyQualifiedNameFor(eClassifier.getEPackage());
        return ePackageQualifiedName + PACKAGE_PATH_SEPARATOR + eClassifier.getName();
    }

    public static String fullyQualifiedNameFor(EPackage ePackage) {
        Preconditions.checkNotNull((Object)ePackage, (Object)"Precondition violation - argument 'ePackage' must not be NULL!");
        ArrayList qualifierChain = Lists.newArrayList();
        for (EPackage currentEPackage = ePackage; currentEPackage != null; currentEPackage = currentEPackage.getESuperPackage()) {
            qualifierChain.add(currentEPackage.getName());
        }
        List qualifiedNameParts = Lists.reverse((List)qualifierChain);
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (String namePart : qualifiedNameParts) {
            builder.append(separator);
            separator = PACKAGE_PATH_SEPARATOR;
            builder.append(namePart);
        }
        return builder.toString();
    }

    public static Set<EClass> eClasses(EPackage ePackage) {
        EList eClassifiers = ePackage.getEClassifiers();
        Set eClasses = eClassifiers.stream().filter(classifier -> classifier instanceof EClass).map(classifier -> (EClass)classifier).collect(Collectors.toSet());
        return Collections.unmodifiableSet(eClasses);
    }

    public static Set<EClass> allEClasses(EPackage ePackage) {
        Set<EPackage> packages = EMFUtils.flattenEPackage(ePackage);
        HashSet eClasses = Sets.newHashSet();
        for (EPackage pack : packages) {
            eClasses.addAll(EMFUtils.eClasses(pack));
        }
        return Collections.unmodifiableSet(eClasses);
    }

    public static Set<EClass> allEClasses(Iterable<? extends EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        return EMFUtils.allEClasses(ePackages.iterator());
    }

    public static Set<EClass> allEClasses(EPackage[] ePackages) {
        Preconditions.checkNotNull((Object)ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        return EMFUtils.allEClasses(Arrays.asList(ePackages));
    }

    public static Set<EClass> allEClasses(Iterator<? extends EPackage> ePackages) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        HashSet eClasses = Sets.newHashSet();
        while (ePackages.hasNext()) {
            EPackage ePackage = ePackages.next();
            eClasses.addAll(EMFUtils.allEClasses(ePackage));
        }
        return Collections.unmodifiableSet(eClasses);
    }

    public static EPackage getEPackageByQualifiedName(Iterable<EPackage> packages, String qualifiedName) {
        Preconditions.checkNotNull(packages, (Object)"Precondition violation - argument 'packages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : packages) {
            EPackage resultPackage = EMFUtils.getEPackageByQualifiedName(ePackage, qualifiedName);
            if (resultPackage == null) continue;
            return resultPackage;
        }
        return null;
    }

    public static EPackage getEPackageByQualifiedName(Iterator<EPackage> packages, String qualifiedName) {
        Preconditions.checkNotNull(packages, (Object)"Precondition violation - argument 'packages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        while (packages.hasNext()) {
            EPackage ePackage = packages.next();
            EPackage resultPackage = EMFUtils.getEPackageByQualifiedName(ePackage, qualifiedName);
            if (resultPackage == null) continue;
            return resultPackage;
        }
        return null;
    }

    public static EPackage getEPackageByQualifiedName(EPackage[] packages, String qualifiedName) {
        Preconditions.checkNotNull((Object)packages, (Object)"Precondition violation - argument 'packages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : packages) {
            EPackage resultPackage = EMFUtils.getEPackageByQualifiedName(ePackage, qualifiedName);
            if (resultPackage == null) continue;
            return resultPackage;
        }
        return null;
    }

    public static EPackage getEPackageByQualifiedName(EPackage rootPackage, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        String[] parts = qualifiedName.split(PACKAGE_PATH_SEPARATOR);
        return EMFUtils.getEPackageByQualifiedName(rootPackage, parts, 0);
    }

    private static EPackage getEPackageByQualifiedName(EPackage ePackage, String[] path, int pathIndex) {
        String name = path[pathIndex];
        if (!ePackage.getName().equals(name)) {
            return null;
        }
        if (pathIndex + 1 >= path.length) {
            return ePackage;
        }
        String subPackageName = path[pathIndex + 1];
        for (EPackage subPackage : ePackage.getESubpackages()) {
            if (!subPackage.getName().equals(subPackageName)) continue;
            return EMFUtils.getEPackageByQualifiedName(subPackage, path, pathIndex + 1);
        }
        return null;
    }

    public static EClassifier getEClassifierByQualifiedName(EPackage rootPackage, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        String[] path = qualifiedName.split(PACKAGE_PATH_SEPARATOR);
        if (path.length <= 1) {
            return null;
        }
        String classifierName = path[path.length - 1];
        String packagePath = qualifiedName.substring(0, qualifiedName.length() - classifierName.length() - PACKAGE_PATH_SEPARATOR.length());
        EPackage ePackage = EMFUtils.getEPackageByQualifiedName(rootPackage, packagePath);
        if (ePackage == null) {
            return null;
        }
        return ePackage.getEClassifier(classifierName);
    }

    public static EClassifier getEClassifierByQualifiedName(Iterable<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : rootPackages) {
            EClassifier classifier = EMFUtils.getEClassifierByQualifiedName(ePackage, qualifiedName);
            if (classifier == null) continue;
            return classifier;
        }
        return null;
    }

    public static EClassifier getEClassifierByQualifiedName(Iterator<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        while (rootPackages.hasNext()) {
            EPackage ePackage = rootPackages.next();
            EClassifier classifier = EMFUtils.getEClassifierByQualifiedName(ePackage, qualifiedName);
            if (classifier == null) continue;
            return classifier;
        }
        return null;
    }

    public static EClassifier getEClassifierByQualifiedName(EPackage[] rootPackages, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : rootPackages) {
            EClassifier classifier = EMFUtils.getEClassifierByQualifiedName(ePackage, qualifiedName);
            if (classifier == null) continue;
            return classifier;
        }
        return null;
    }

    public static EClass getEClassByQualifiedName(EPackage rootPackage, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        EClassifier eClassifier = EMFUtils.getEClassifierByQualifiedName(rootPackage, qualifiedName);
        return (EClass)eClassifier;
    }

    public static EClass getEClassByQualifiedName(Iterable<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        EClassifier eClassifier = EMFUtils.getEClassifierByQualifiedName(rootPackages, qualifiedName);
        return (EClass)eClassifier;
    }

    public static EClass getEClassByQualifiedName(Iterator<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        EClassifier eClassifier = EMFUtils.getEClassifierByQualifiedName(rootPackages, qualifiedName);
        return (EClass)eClassifier;
    }

    public static EClass getEClassByQualifiedName(EPackage[] rootPackages, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        EClassifier eClassifier = EMFUtils.getEClassifierByQualifiedName(rootPackages, qualifiedName);
        return (EClass)eClassifier;
    }

    public static EStructuralFeature getFeatureByQualifiedName(EPackage rootPackage, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getFeatureByQualifiedName(rootPackage, qualifiedName, EStructuralFeature.class);
    }

    public static EStructuralFeature getFeatureByQualifiedName(Iterable<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : rootPackages) {
            EStructuralFeature feature = EMFUtils.getFeatureByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    public static EStructuralFeature getFeatureByQualifiedName(EPackage[] rootPackages, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : rootPackages) {
            EStructuralFeature feature = EMFUtils.getFeatureByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    public static EStructuralFeature getFeatureByQualifiedName(Iterator<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        while (rootPackages.hasNext()) {
            EPackage ePackage = rootPackages.next();
            EStructuralFeature feature = EMFUtils.getFeatureByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    private static <T extends EStructuralFeature> T getFeatureByQualifiedName(EPackage rootPackage, String qualifiedName, Class<T> featureClass) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        Preconditions.checkNotNull(featureClass, (Object)"Precondition violation - argument 'featureClass' must not be NULL!");
        int featureSeparatorIndex = qualifiedName.lastIndexOf(CLASS_FEATURE_SEPARATOR);
        if (featureSeparatorIndex < 0) {
            return null;
        }
        String featureName = qualifiedName.substring(featureSeparatorIndex + 1, qualifiedName.length());
        String qualifiedClassName = qualifiedName.substring(0, featureSeparatorIndex);
        EClass eClass = EMFUtils.getEClassByQualifiedName(rootPackage, qualifiedClassName);
        if (eClass == null) {
            return null;
        }
        if (featureClass.equals(EStructuralFeature.class)) {
            return (T)eClass.getEStructuralFeature(featureName);
        }
        if (featureClass.equals(EAttribute.class)) {
            return (T)EMFUtils.getEAttribute(eClass, featureName);
        }
        if (featureClass.equals(EReference.class)) {
            return (T)EMFUtils.getEReference(eClass, featureName);
        }
        throw new RuntimeException("Unknown subtype of EStructuralFeature: " + featureClass.getCanonicalName());
    }

    public static EAttribute getEAttributeByQualifiedName(EPackage rootPackage, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getFeatureByQualifiedName(rootPackage, qualifiedName, EAttribute.class);
    }

    public static EAttribute getEAttributeByQualifiedName(Iterable<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : rootPackages) {
            EAttribute feature = EMFUtils.getEAttributeByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    public static EAttribute getEAttributeByQualifiedName(EPackage[] rootPackages, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : rootPackages) {
            EAttribute feature = EMFUtils.getEAttributeByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    public static EAttribute getEAttributeByQualifiedName(Iterator<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        while (rootPackages.hasNext()) {
            EPackage ePackage = rootPackages.next();
            EAttribute feature = EMFUtils.getEAttributeByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    public static EReference getEReferenceByQualifiedName(EPackage rootPackage, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        return EMFUtils.getFeatureByQualifiedName(rootPackage, qualifiedName, EReference.class);
    }

    public static EReference getEReferenceByQualifiedName(Iterable<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : rootPackages) {
            EReference feature = EMFUtils.getEReferenceByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    public static EReference getEReferenceByQualifiedName(EPackage[] rootPackages, String qualifiedName) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        for (EPackage ePackage : rootPackages) {
            EReference feature = EMFUtils.getEReferenceByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    public static EReference getEReferenceByQualifiedName(Iterator<? extends EPackage> rootPackages, String qualifiedName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"Precondition violation - argument 'qualifiedName' must not be NULL!");
        while (rootPackages.hasNext()) {
            EPackage ePackage = rootPackages.next();
            EReference feature = EMFUtils.getEReferenceByQualifiedName(ePackage, qualifiedName);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    public static EPackage getEPackageBySimpleName(EPackage rootPackage, String simpleName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEPackageBySimpleName(Collections.singleton(rootPackage), simpleName);
    }

    public static EPackage getEPackageBySimpleName(Iterable<? extends EPackage> rootPackages, String simpleName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEPackageBySimpleName(rootPackages.iterator(), simpleName);
    }

    public static EPackage getEPackageBySimpleName(Iterator<? extends EPackage> rootPackages, String simpleName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        Set<EPackage> allPackages = EMFUtils.flattenEPackages(rootPackages);
        EPackage resultPackage = null;
        for (EPackage ePackage : allPackages) {
            if (!ePackage.getName().equals(simpleName)) continue;
            if (resultPackage == null) {
                resultPackage = ePackage;
                continue;
            }
            throw new NameResolutionException("The simple EPackage name '" + simpleName + "' is ambiguous! Candidates are '" + EMFUtils.fullyQualifiedNameFor(resultPackage) + "' and '" + EMFUtils.fullyQualifiedNameFor(ePackage) + "' (potential others as well).");
        }
        return resultPackage;
    }

    public static EPackage getEPackageBySimpleName(EPackage[] rootPackages, String simpleName) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEPackageBySimpleName(Arrays.asList(rootPackages), simpleName);
    }

    public static EClassifier getEClassifierBySimpleName(EPackage rootPackage, String simpleName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEClassifierBySimpleName(Collections.singleton(rootPackage), simpleName);
    }

    public static EClassifier getEClassifierBySimpleName(Iterable<? extends EPackage> rootPackages, String simpleName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEClassifierBySimpleName(rootPackages.iterator(), simpleName);
    }

    public static EClassifier getEClassifierBySimpleName(EPackage[] rootPackages, String simpleName) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return EMFUtils.getEClassifierBySimpleName(Arrays.asList(rootPackages), simpleName);
    }

    public static EClassifier getEClassifierBySimpleName(Iterator<? extends EPackage> rootPackages, String simpleName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        Set<EPackage> allPackages = EMFUtils.flattenEPackages(rootPackages);
        EClassifier resultClassifier = null;
        for (EPackage ePackage : allPackages) {
            EClassifier classifier = ePackage.getEClassifier(simpleName);
            if (classifier == null) continue;
            if (resultClassifier == null) {
                resultClassifier = classifier;
                continue;
            }
            throw new NameResolutionException("The simple EClassifier name '" + simpleName + "' is ambiguous! Candidates are '" + EMFUtils.fullyQualifiedNameFor(resultClassifier) + "' and '" + EMFUtils.fullyQualifiedNameFor(classifier) + "' (potential others as well).");
        }
        return resultClassifier;
    }

    public static EClass getEClassBySimpleName(EPackage rootPackage, String simpleName) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return (EClass)EMFUtils.getEClassifierBySimpleName(rootPackage, simpleName);
    }

    public static EClass getEClassBySimpleName(Iterable<? extends EPackage> rootPackages, String simpleName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return (EClass)EMFUtils.getEClassifierBySimpleName(rootPackages, simpleName);
    }

    public static EClass getEClassBySimpleName(EPackage[] rootPackages, String simpleName) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return (EClass)EMFUtils.getEClassifierBySimpleName(rootPackages, simpleName);
    }

    public static EClass getEClassBySimpleName(Iterator<? extends EPackage> rootPackages, String simpleName) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        Preconditions.checkNotNull((Object)simpleName, (Object)"Precondition violation - argument 'simpleName' must not be NULL!");
        return (EClass)EMFUtils.getEClassifierBySimpleName(rootPackages, simpleName);
    }

    public static <T> T eGet(EObject eObject, String featureName) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        Preconditions.checkNotNull((Object)featureName, (Object)"Precondition violation - argument 'featureName' must not be NULL!");
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            throw new IllegalArgumentException("EClass '" + eObject.eClass().getName() + "' does not have a feature named '" + featureName + "'!");
        }
        return (T)eObject.eGet(feature);
    }

    public static Set<EReference> getEReferencesToEClass(EPackage ePackage, EClass targetEClass) {
        Preconditions.checkNotNull((Object)ePackage, (Object)"Precondition violation - argument 'ePackage' must not be NULL!");
        Preconditions.checkNotNull((Object)targetEClass, (Object)"Precondition violation - argument 'targetEClass' must not be NULL!");
        return EMFUtils.getEReferencesToEClass(Collections.singleton(ePackage), targetEClass);
    }

    public static Set<EReference> getEReferencesToEClass(Iterable<? extends EPackage> ePackages, EClass targetEClass) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Preconditions.checkNotNull((Object)targetEClass, (Object)"Precondition violation - argument 'targetEClass' must not be NULL!");
        return EMFUtils.getEReferencesToEClass(ePackages.iterator(), targetEClass);
    }

    public static Set<EReference> getEReferencesToEClass(EPackage[] ePackages, EClass targetEClass) {
        Preconditions.checkNotNull((Object)ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Preconditions.checkNotNull((Object)targetEClass, (Object)"Precondition violation - argument 'targetEClass' must not be NULL!");
        return EMFUtils.getEReferencesToEClass(Arrays.asList(ePackages), targetEClass);
    }

    public static Set<EReference> getEReferencesToEClass(Iterator<? extends EPackage> ePackages, EClass targetEClass) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Preconditions.checkNotNull((Object)targetEClass, (Object)"Precondition violation - argument 'targetEClass' must not be NULL!");
        HashSet resultSet = Sets.newHashSet();
        Set<EPackage> packages = EMFUtils.flattenEPackages(ePackages);
        for (EPackage ePackage : packages) {
            for (EClass eClass : EMFUtils.eClasses(ePackage)) {
                for (EReference eReference : eClass.getEAllReferences()) {
                    if (!eReference.getEReferenceType().isSuperTypeOf(targetEClass)) continue;
                    resultSet.add(eReference);
                }
            }
        }
        return resultSet;
    }

    public static SetMultimap<EClass, EReference> eClassToIncomingEReferences(Iterable<? extends EPackage> rootPackages) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        HashMultimap multimap = HashMultimap.create();
        for (EPackage ePackage : rootPackages) {
            for (EClass eClass : EMFUtils.allEClasses(ePackage)) {
                multimap.putAll((Object)eClass, EMFUtils.getEReferencesToEClass(rootPackages, eClass));
            }
        }
        return multimap;
    }

    public static SetMultimap<EClass, EReference> eClassToIncomingEReferences(Iterator<? extends EPackage> rootPackages) {
        Preconditions.checkNotNull(rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        return EMFUtils.eClassToIncomingEReferences(Lists.newArrayList(rootPackages));
    }

    public static SetMultimap<EClass, EReference> eClassToIncomingEReferences(EPackage[] rootPackages) {
        Preconditions.checkNotNull((Object)rootPackages, (Object)"Precondition violation - argument 'rootPackages' must not be NULL!");
        return EMFUtils.eClassToIncomingEReferences(Arrays.asList(rootPackages));
    }

    public static SetMultimap<EClass, EReference> eClassToIncomingEReferences(EPackage rootPackage) {
        Preconditions.checkNotNull((Object)rootPackage, (Object)"Precondition violation - argument 'rootPackage' must not be NULL!");
        return EMFUtils.eClassToIncomingEReferences(Collections.singleton(rootPackage));
    }
}

