/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.chronos.chronograph.api.branch.ChronoGraphBranchManager;
import org.chronos.chronograph.api.branch.GraphBranch;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronosphere.api.ChronoSphereBranchManager;
import org.chronos.chronosphere.api.SphereBranch;
import org.chronos.chronosphere.impl.SphereBranchImpl;

public class ChronoSphereBranchManagerImpl
implements ChronoSphereBranchManager {
    private final ChronoGraph graph;
    private final Map<GraphBranch, SphereBranch> backingBranchToSphereBranch;

    public ChronoSphereBranchManagerImpl(ChronoGraph graph) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        this.graph = graph;
        this.backingBranchToSphereBranch = Maps.newHashMap();
    }

    @Override
    public SphereBranch createBranch(String branchName) {
        GraphBranch branch = this.getChronoGraphBranchManager().createBranch(branchName);
        return this.getOrCreateSphereBranch(branch);
    }

    @Override
    public SphereBranch createBranch(String branchName, long branchingTimestamp) {
        GraphBranch branch = this.getChronoGraphBranchManager().createBranch(branchName, branchingTimestamp);
        return this.getOrCreateSphereBranch(branch);
    }

    @Override
    public SphereBranch createBranch(String parentName, String newBranchName) {
        GraphBranch branch = this.getChronoGraphBranchManager().createBranch(parentName, newBranchName);
        return this.getOrCreateSphereBranch(branch);
    }

    @Override
    public SphereBranch createBranch(String parentName, String newBranchName, long branchingTimestamp) {
        GraphBranch branch = this.getChronoGraphBranchManager().createBranch(parentName, newBranchName, branchingTimestamp);
        return this.getOrCreateSphereBranch(branch);
    }

    @Override
    public boolean existsBranch(String branchName) {
        return this.getChronoGraphBranchManager().existsBranch(branchName);
    }

    @Override
    public SphereBranch getBranch(String branchName) {
        GraphBranch backingBranch = this.getChronoGraphBranchManager().getBranch(branchName);
        return this.getOrCreateSphereBranch(backingBranch);
    }

    @Override
    public Set<String> getBranchNames() {
        return this.getChronoGraphBranchManager().getBranchNames();
    }

    @Override
    public Set<SphereBranch> getBranches() {
        Set branches = this.getChronoGraphBranchManager().getBranches();
        return branches.stream().map(backingBranch -> this.getOrCreateSphereBranch((GraphBranch)backingBranch)).collect(Collectors.toSet());
    }

    private ChronoGraphBranchManager getChronoGraphBranchManager() {
        return this.graph.getBranchManager();
    }

    private SphereBranch getOrCreateSphereBranch(GraphBranch backingBranch) {
        Preconditions.checkNotNull((Object)backingBranch, (Object)"Precondition violation - argument 'backingBranch' must not be NULL!");
        SphereBranch graphBranch = this.backingBranchToSphereBranch.get(backingBranch);
        if (graphBranch != null) {
            return graphBranch;
        }
        if (backingBranch.getOrigin() == null) {
            graphBranch = SphereBranchImpl.createMasterBranch(backingBranch);
        } else {
            SphereBranch originBranch = this.getOrCreateSphereBranch(backingBranch.getOrigin());
            graphBranch = SphereBranchImpl.createBranch(backingBranch, originBranch);
        }
        this.backingBranchToSphereBranch.put(backingBranch, graphBranch);
        return graphBranch;
    }
}

