/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronosphere.api.ChronoSphere;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.api.MetaModelEvolutionController;
import org.chronos.chronosphere.api.MetaModelEvolutionIncubator;
import org.chronos.chronosphere.emf.impl.ChronoEFactory;
import org.chronos.chronosphere.impl.evolution.MetaModelEvolutionProcess;
import org.chronos.chronosphere.internal.api.ChronoSphereEPackageManagerInternal;
import org.chronos.chronosphere.internal.api.ChronoSphereInternal;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.EPackageBundle;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;

public class ChronoSphereEPackageManagerImpl
implements ChronoSphereEPackageManagerInternal {
    private ChronoSphereInternal owningSphere;

    public ChronoSphereEPackageManagerImpl(ChronoSphereInternal owningSphere) {
        Preconditions.checkNotNull((Object)owningSphere, (Object)"Precondition violation - argument 'owningSphere' must not be NULL!");
        this.owningSphere = owningSphere;
    }

    @Override
    public void registerOrUpdateEPackages(Iterator<? extends EPackage> ePackages, String branchName) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Preconditions.checkNotNull((Object)branchName, (Object)"Precondition violation - argument 'branchName' must not be NULL!");
        ArrayList packages = Lists.newArrayList();
        ePackages.forEachRemaining(pack -> packages.add(pack));
        EPackageBundle bundle = EPackageBundle.of(packages);
        try (ChronoGraph txGraph = this.owningSphere.getRootGraph().tx().createThreadedTx(branchName);){
            this.owningSphere.getEPackageToGraphMapper().mapToGraph(txGraph, bundle);
            txGraph.tx().commit();
        }
        packages.forEach(ePackage -> ePackage.setEFactoryInstance((EFactory)new ChronoEFactory()));
    }

    @Override
    public void deleteEPackages(Iterator<? extends EPackage> ePackages, String branchName) {
        Preconditions.checkNotNull(ePackages, (Object)"Precondition violation - argument 'ePackages' must not be NULL!");
        Preconditions.checkNotNull((Object)branchName, (Object)"Precondition violation - argument 'branchName' must not be NULL!");
        ArrayList packages = Lists.newArrayList();
        ePackages.forEachRemaining(pack -> packages.add(pack));
        EPackageBundle bundle = EPackageBundle.of(packages);
        try (ChronoGraph txGraph = this.owningSphere.getRootGraph().tx().createThreadedTx(branchName);){
            this.owningSphere.getEPackageToGraphMapper().deleteInGraph(txGraph, bundle);
            txGraph.tx().commit();
        }
    }

    @Override
    public Set<EPackage> getRegisteredEPackages(String branchName) {
        Preconditions.checkNotNull((Object)branchName, (Object)"Precondition violation - argument 'branchName' must not be NULL!");
        Preconditions.checkArgument((boolean)this.owningSphere.getBranchManager().existsBranch(branchName), (Object)"Precondition violation - argument 'branchName' must refer to an existing branch!");
        try (ChronoGraph txGraph = this.owningSphere.getRootGraph().tx().createThreadedTx(branchName);){
            ChronoEPackageRegistry registry = this.owningSphere.getEPackageToGraphMapper().readChronoEPackageRegistryFromGraph(txGraph);
            Set<EPackage> set = registry.getEPackages();
            return set;
        }
    }

    @Override
    public void evolveMetamodel(String branch, MetaModelEvolutionController controller, Iterable<? extends EPackage> newEPackages) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkNotNull((Object)controller, (Object)"Precondition violation - argument 'controller' must not be NULL!");
        Preconditions.checkNotNull(newEPackages, (Object)"Precondition violation - argument 'newEPackages' must not be NULL!");
        ChronoSphereInternal repo = this.owningSphere;
        MetaModelEvolutionProcess.execute((ChronoSphere)repo, branch, controller, newEPackages);
    }

    @Override
    public void evolveMetamodel(String branch, MetaModelEvolutionIncubator incubator, Iterable<? extends EPackage> newEPackages) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkNotNull((Object)incubator, (Object)"Precondition violation - argument 'incubator' must not be NULL!");
        Preconditions.checkNotNull(newEPackages, (Object)"Precondition violation - argument 'newEPackages' must not be NULL!");
        ChronoSphereInternal repo = this.owningSphere;
        MetaModelEvolutionProcess.execute((ChronoSphere)repo, branch, incubator, newEPackages);
    }

    @Override
    public void overrideEPackages(ChronoSphereTransaction transaction, Iterable<? extends EPackage> newEPackages) {
        Preconditions.checkNotNull((Object)transaction, (Object)"Precondition violation - argument 'transaction' must not be NULL!");
        Preconditions.checkNotNull(newEPackages, (Object)"Precondition violation - argument 'newEPackages' must not be NULL!");
        ChronoSphereTransactionInternal tx = (ChronoSphereTransactionInternal)transaction;
        ChronoGraph graph = tx.getGraph();
        EPackageBundle bundle = EPackageBundle.of(newEPackages);
        this.owningSphere.getEPackageToGraphMapper().mapToGraph(graph, bundle);
        tx.reloadEPackageRegistryFromGraph();
    }
}

