/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl;

import com.google.common.base.Preconditions;
import org.chronos.chronograph.api.index.ChronoGraphIndex;
import org.chronos.chronograph.api.index.ChronoGraphIndexManager;
import org.chronos.chronosphere.api.ChronoSphereIndexManager;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.api.SphereBranch;
import org.chronos.chronosphere.internal.api.ChronoSphereInternal;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.eclipse.emf.ecore.EAttribute;

public class ChronoSphereIndexManagerImpl
implements ChronoSphereIndexManager {
    private final ChronoSphereInternal owningSphere;
    private final SphereBranch owningBranch;

    public ChronoSphereIndexManagerImpl(ChronoSphereInternal owningSphere, SphereBranch owningBranch) {
        Preconditions.checkNotNull((Object)owningSphere, (Object)"Precondition violation - argument 'owningSphere' must not be NULL!");
        this.owningSphere = owningSphere;
        this.owningBranch = owningBranch;
    }

    @Override
    public boolean createIndexOn(EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        try (ChronoSphereTransaction tx = this.owningSphere.tx(this.owningBranch.getName());){
            ChronoEPackageRegistry registry = ((ChronoSphereTransactionInternal)tx).getEPackageRegistry();
            String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, eAttribute);
            if (propertyKey == null) {
                throw new IllegalArgumentException("The given EAttribute '" + eAttribute.getName() + "' is not part of a registered EPackage! Please register the EPackage first.");
            }
            if (this.getGraphIndexManager().isVertexPropertyIndexed(propertyKey)) {
                boolean bl = false;
                return bl;
            }
            this.getGraphIndexManager().create().stringIndex().onVertexProperty(propertyKey).build();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean existsIndexOn(EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        try (ChronoSphereTransaction tx = this.owningSphere.tx(this.owningBranch.getName());){
            ChronoEPackageRegistry registry = ((ChronoSphereTransactionInternal)tx).getEPackageRegistry();
            String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, eAttribute);
            if (propertyKey == null) {
                throw new IllegalArgumentException("The given EAttribute '" + eAttribute.getName() + "' is not part of a registered EPackage! Please register the EPackage first.");
            }
            boolean bl = this.getGraphIndexManager().isVertexPropertyIndexed(propertyKey);
            return bl;
        }
    }

    @Override
    public boolean dropIndexOn(EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        try (ChronoSphereTransaction tx = this.owningSphere.tx(this.owningBranch.getName());){
            ChronoEPackageRegistry registry = ((ChronoSphereTransactionInternal)tx).getEPackageRegistry();
            String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, eAttribute);
            if (propertyKey == null) {
                throw new IllegalArgumentException("The given EAttribute '" + eAttribute.getName() + "' is not part of a registered EPackage! Please register the EPackage first.");
            }
            ChronoGraphIndex index = this.getGraphIndexManager().getVertexIndex(propertyKey);
            if (index == null) {
                boolean bl = false;
                return bl;
            }
            this.getGraphIndexManager().dropIndex(index);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void reindexAll() {
        this.getGraphIndexManager().reindexAll();
    }

    @Override
    public void reindex(EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        try (ChronoSphereTransaction tx = this.owningSphere.tx(this.owningBranch.getName());){
            ChronoEPackageRegistry registry = ((ChronoSphereTransactionInternal)tx).getEPackageRegistry();
            String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, eAttribute);
            if (propertyKey == null) {
                throw new IllegalArgumentException("The given EAttribute '" + eAttribute.getName() + "' is not part of a registered EPackage! Please register the EPackage first.");
            }
            this.getGraphIndexManager().reindexAll();
        }
    }

    @Override
    public boolean isIndexDirty(EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        try (ChronoSphereTransaction tx = this.owningSphere.tx(this.owningBranch.getName());){
            ChronoEPackageRegistry registry = ((ChronoSphereTransactionInternal)tx).getEPackageRegistry();
            String propertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, eAttribute);
            if (propertyKey == null) {
                throw new IllegalArgumentException("The given EAttribute '" + eAttribute.getName() + "' is not part of a registered EPackage! Please register the EPackage first.");
            }
            boolean bl = this.getGraphIndexManager().getDirtyIndices().stream().anyMatch(index -> index.getIndexedProperty().equals(propertyKey));
            return bl;
        }
    }

    protected ChronoGraphIndexManager getGraphIndexManager() {
        return this.owningSphere.getRootGraph().getIndexManager(this.owningBranch.getName());
    }
}

