/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.chronos.chronograph.api.branch.GraphBranch;
import org.chronos.chronosphere.api.SphereBranch;

public class SphereBranchImpl
implements SphereBranch {
    private final GraphBranch backingBranch;
    private final SphereBranch origin;

    public static SphereBranchImpl createMasterBranch(GraphBranch backingMasterBranch) {
        Preconditions.checkNotNull((Object)backingMasterBranch, (Object)"Precondition violation - argument 'backingMasterBranch' must not be NULL!");
        Preconditions.checkArgument((boolean)backingMasterBranch.getName().equals("master"), (Object)"Precondition violation - the backing branch is not the master branch!");
        Preconditions.checkArgument((backingMasterBranch.getOrigin() == null ? 1 : 0) != 0, (Object)"Precondition violation - the backing branch is not the master branch!");
        return new SphereBranchImpl(backingMasterBranch, null);
    }

    public static SphereBranchImpl createBranch(GraphBranch backingBranch, SphereBranch origin) {
        Preconditions.checkNotNull((Object)backingBranch, (Object)"Precondition violation - argument 'backingMasterBranch' must not be NULL!");
        Preconditions.checkNotNull((Object)origin, (Object)"Precondition violation - argument 'origin' must not be NULL!");
        Preconditions.checkArgument((boolean)backingBranch.getOrigin().getName().equals(origin.getName()), (Object)"Precondition violation - the arguments do not refer to the same branch!");
        return new SphereBranchImpl(backingBranch, origin);
    }

    protected SphereBranchImpl(GraphBranch backingBranch, SphereBranch origin) {
        Preconditions.checkNotNull((Object)backingBranch, (Object)"Precondition violation - argument 'backingBranch' must not be NULL!");
        this.backingBranch = backingBranch;
        this.origin = origin;
    }

    @Override
    public String getName() {
        return this.backingBranch.getName();
    }

    @Override
    public SphereBranch getOrigin() {
        return this.origin;
    }

    @Override
    public long getBranchingTimestamp() {
        return this.backingBranch.getBranchingTimestamp();
    }

    @Override
    public List<SphereBranch> getOriginsRecursive() {
        if (this.origin == null) {
            return Lists.newArrayList();
        }
        List<SphereBranch> origins = this.getOrigin().getOriginsRecursive();
        origins.add(this.getOrigin());
        return origins;
    }

    @Override
    public long getNow() {
        return this.backingBranch.getNow();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backingBranch == null ? 0 : this.backingBranch.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SphereBranchImpl other = (SphereBranchImpl)obj;
        return !(this.backingBranch == null ? other.backingBranch != null : !this.backingBranch.equals(other.backingBranch));
    }
}

