/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.Configuration;
import org.chronos.chronodb.api.Order;
import org.chronos.chronodb.internal.impl.engines.base.ChronosInternalCommitMetadata;
import org.chronos.chronograph.api.index.ChronoGraphIndex;
import org.chronos.chronograph.api.index.ChronoGraphIndexManager;
import org.chronos.chronograph.api.structure.ChronoGraph;
import org.chronos.chronosphere.api.ChronoSphere;
import org.chronos.chronosphere.api.ChronoSphereBranchManager;
import org.chronos.chronosphere.api.ChronoSphereEPackageManager;
import org.chronos.chronosphere.api.ChronoSphereIndexManager;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.api.SphereBranch;
import org.chronos.chronosphere.api.exceptions.ChronoSphereConfigurationException;
import org.chronos.chronosphere.impl.ChronoSphereBranchManagerImpl;
import org.chronos.chronosphere.impl.ChronoSphereEPackageManagerImpl;
import org.chronos.chronosphere.impl.ChronoSphereIndexManagerImpl;
import org.chronos.chronosphere.impl.transaction.ChronoSphereTransactionImpl;
import org.chronos.chronosphere.internal.api.ChronoSphereInternal;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.configuration.api.ChronoSphereConfiguration;
import org.chronos.chronosphere.internal.configuration.impl.ChronoSphereConfigurationImpl;
import org.chronos.chronosphere.internal.ogm.api.EObjectToGraphMapper;
import org.chronos.chronosphere.internal.ogm.api.EPackageToGraphMapper;
import org.chronos.chronosphere.internal.ogm.impl.EObjectToGraphMapperImpl;
import org.chronos.chronosphere.internal.ogm.impl.EPackageToGraphMapperImpl;
import org.chronos.common.configuration.ChronosConfigurationUtil;
import org.chronos.common.version.ChronosVersion;
import org.eclipse.emf.ecore.EObject;

public class StandardChronoSphere
implements ChronoSphere,
ChronoSphereInternal {
    private final ChronoGraph graph;
    private final ChronoSphereConfiguration configuration;
    private final ChronoSphereBranchManager branchManager;
    private final ChronoSphereEPackageManager ePackageManager;
    private final EObjectToGraphMapper eObjectToGraphMapper;
    private final EPackageToGraphMapper ePackageToGraphMapper;
    private final Lock branchLock;
    private final Map<SphereBranch, ChronoSphereIndexManager> branchToIndexManager;

    public StandardChronoSphere(ChronoGraph graph, Configuration configuration) {
        Preconditions.checkNotNull((Object)graph, (Object)"Precondition violation - argument 'graph' must not be NULL!");
        Preconditions.checkNotNull((Object)configuration, (Object)"Precondition violation - argument 'configuration' must not be NULL!");
        this.graph = graph;
        this.configuration = (ChronoSphereConfiguration)ChronosConfigurationUtil.build((Configuration)configuration, ChronoSphereConfigurationImpl.class);
        this.eObjectToGraphMapper = new EObjectToGraphMapperImpl();
        this.ePackageToGraphMapper = new EPackageToGraphMapperImpl();
        this.branchManager = new ChronoSphereBranchManagerImpl(graph);
        this.ePackageManager = new ChronoSphereEPackageManagerImpl(this);
        this.branchLock = new ReentrantLock(true);
        this.branchToIndexManager = Maps.newHashMap();
        this.ensureGraphFormatIsCompatible();
        this.setUpDefaultGraphIndicesIfNecessary();
    }

    @Override
    public ChronoSphereConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void close() {
        this.graph.close();
    }

    @Override
    public boolean isClosed() {
        return this.graph.isClosed();
    }

    @Override
    public ChronoSphereBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public ChronoSphereEPackageManager getEPackageManager() {
        return this.ePackageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChronoSphereIndexManager getIndexManager(String branchName) {
        Preconditions.checkNotNull((Object)branchName, (Object)"Precondition violation - argument 'branchName' must not be NULL!");
        SphereBranch branch = this.getBranchManager().getBranch(branchName);
        this.branchLock.lock();
        try {
            ChronoSphereIndexManager indexManager = this.branchToIndexManager.get(branch);
            if (indexManager != null) {
                ChronoSphereIndexManager chronoSphereIndexManager = indexManager;
                return chronoSphereIndexManager;
            }
            indexManager = new ChronoSphereIndexManagerImpl(this, branch);
            this.branchToIndexManager.put(branch, indexManager);
            ChronoSphereIndexManager chronoSphereIndexManager = indexManager;
            return chronoSphereIndexManager;
        }
        finally {
            this.branchLock.unlock();
        }
    }

    @Override
    public ChronoSphereTransaction tx() {
        ChronoGraph txGraph = this.getRootGraph().tx().createThreadedTx();
        return new ChronoSphereTransactionImpl(this, txGraph);
    }

    @Override
    public ChronoSphereTransaction tx(long timestamp) {
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'timestamp' must not be negative!");
        ChronoGraph txGraph = this.getRootGraph().tx().createThreadedTx(timestamp);
        return new ChronoSphereTransactionImpl(this, txGraph);
    }

    @Override
    public ChronoSphereTransaction tx(Date date) {
        Preconditions.checkNotNull((Object)date, (Object)"Precondition violation - argument 'date' must not be NULL!");
        return this.tx(date.getTime());
    }

    @Override
    public ChronoSphereTransaction tx(String branchName) {
        Preconditions.checkNotNull((Object)branchName, (Object)"Precondition violation - argument 'branchName' must not be NULL!");
        ChronoGraph txGraph = this.getRootGraph().tx().createThreadedTx(branchName);
        return new ChronoSphereTransactionImpl(this, txGraph);
    }

    @Override
    public ChronoSphereTransaction tx(String branchName, long timestamp) {
        Preconditions.checkNotNull((Object)branchName, (Object)"Precondition violation - argument 'branchName' must not be NULL!");
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'timestamp' must not be negative!");
        ChronoGraph txGraph = this.getRootGraph().tx().createThreadedTx(branchName, timestamp);
        return new ChronoSphereTransactionImpl(this, txGraph);
    }

    @Override
    public ChronoSphereTransaction tx(String branchName, Date date) {
        Preconditions.checkNotNull((Object)branchName, (Object)"Precondition violation - argument 'branchName' must not be NULL!");
        Preconditions.checkNotNull((Object)date, (Object)"Precondition violation - argument 'date' must not be NULL!");
        return this.tx(branchName, date.getTime());
    }

    @Override
    public void batchInsertModelData(String branch, Iterator<EObject> model) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((boolean)this.getBranchManager().existsBranch(branch), (Object)"Precondition violation - argument 'branch' must refer to an existing branch!");
        Preconditions.checkNotNull(model, (Object)"Precondition violation - argument 'model' must not be NULL!");
        try (ChronoSphereTransactionInternal tx = (ChronoSphereTransactionInternal)this.tx(branch);){
            tx.commitIncremental();
            tx.batchInsert(model);
            tx.commit();
        }
    }

    @Override
    public long getNow(String branchName) {
        Preconditions.checkNotNull((Object)branchName, (Object)"Precondition violation - argument 'branchName' must not be NULL!");
        return this.graph.getNow(branchName);
    }

    @Override
    public Object getCommitMetadata(String branch, long timestamp) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'timestamp' must not be negative!");
        Preconditions.checkArgument((timestamp <= this.getNow(branch) ? 1 : 0) != 0, (Object)"Precondition violation - argument 'timestamp' must not be larger than the latest commit timestamp!");
        return this.graph.getCommitMetadata(branch, timestamp);
    }

    @Override
    public Iterator<Long> getCommitTimestampsBetween(String branch, long from, long to, Order order) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((from >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'from' must not be negative!");
        Preconditions.checkArgument((to >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'to' must not be negative!");
        Preconditions.checkNotNull((Object)order, (Object)"Precondition violation - argument 'order' must not be NULL!");
        return this.graph.getCommitTimestampsBetween(branch, from, to, order);
    }

    @Override
    public Iterator<Map.Entry<Long, Object>> getCommitMetadataBetween(String branch, long from, long to, Order order) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((from >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'from' must not be negative!");
        Preconditions.checkArgument((to >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'to' must not be negative!");
        Preconditions.checkNotNull((Object)order, (Object)"Precondition violation - argument 'order' must not be NULL!");
        return this.graph.getCommitMetadataBetween(branch, from, to, order);
    }

    @Override
    public Iterator<Long> getCommitTimestampsPaged(String branch, long minTimestamp, long maxTimestamp, int pageSize, int pageIndex, Order order) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((minTimestamp >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'minTimestamp' must not be negative!");
        Preconditions.checkArgument((maxTimestamp >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'maxTimestamp' must not be negative!");
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'pageSize' must be greater than zero!");
        Preconditions.checkArgument((pageIndex >= 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'pageIndex' must not be negative!");
        Preconditions.checkNotNull((Object)order, (Object)"Precondition violation - argument 'order' must not be NULL!");
        return this.graph.getCommitTimestampsPaged(branch, minTimestamp, maxTimestamp, pageSize, pageIndex, order);
    }

    @Override
    public Iterator<Map.Entry<Long, Object>> getCommitMetadataPaged(String branch, long minTimestamp, long maxTimestamp, int pageSize, int pageIndex, Order order) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((minTimestamp >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'minTimestamp' must not be negative!");
        Preconditions.checkArgument((maxTimestamp >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'maxTimestamp' must not be negative!");
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'pageSize' must be greater than zero!");
        Preconditions.checkArgument((pageIndex >= 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'pageIndex' must not be negative!");
        Preconditions.checkNotNull((Object)order, (Object)"Precondition violation - argument 'order' must not be NULL!");
        return this.graph.getCommitMetadataPaged(branch, minTimestamp, maxTimestamp, pageSize, pageIndex, order);
    }

    @Override
    public int countCommitTimestampsBetween(String branch, long from, long to) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkArgument((from >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'from' must not be negative!");
        Preconditions.checkArgument((to >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'to' must not be negative!");
        return this.graph.countCommitTimestampsBetween(branch, from, to);
    }

    @Override
    public int countCommitTimestamps(String branch) {
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        return this.graph.countCommitTimestamps(branch);
    }

    @Override
    public ChronoGraph getRootGraph() {
        return this.graph;
    }

    @Override
    public EObjectToGraphMapper getEObjectToGraphMapper() {
        return this.eObjectToGraphMapper;
    }

    @Override
    public EPackageToGraphMapper getEPackageToGraphMapper() {
        return this.ePackageToGraphMapper;
    }

    private void setUpDefaultGraphIndicesIfNecessary() {
        ChronoGraphIndex classIndex;
        ChronoGraphIndexManager indexManager = this.getRootGraph().getIndexManager();
        ChronoGraphIndex kindIndex = indexManager.getVertexIndex("kind");
        if (kindIndex == null) {
            indexManager.create().stringIndex().onVertexProperty("kind").build();
        }
        if ((classIndex = indexManager.getVertexIndex("eClass")) == null) {
            indexManager.create().stringIndex().onVertexProperty("eClass").build();
        }
    }

    private void ensureGraphFormatIsCompatible() {
        try (ChronoGraph txGraph = this.graph.tx().createThreadedTx();){
            String formatVersionString = txGraph.variables().get("chronosphere.graphformat.version").orElse(null);
            ChronosVersion currentVersion = ChronosVersion.getCurrentVersion();
            if (formatVersionString == null) {
                boolean isEmpty = txGraph.getCommitMetadataAfter(0L, Integer.MAX_VALUE).stream().allMatch(m -> m.getValue() instanceof ChronosInternalCommitMetadata);
                if (isEmpty && this.graph.getBranchManager().getBranchNames().equals(Collections.singleton("master"))) {
                    txGraph.variables().set("chronosphere.graphformat.version", (Object)currentVersion.toString());
                    txGraph.tx().commit((Object)("ChronoSphere Graph Format version update to " + currentVersion));
                    return;
                }
                throw new ChronoSphereConfigurationException("This instance of ChronoSphere was created by a ChronoSphere version lower than 0.9.x. A persistence format change has occurred since then. To migrate your data, please export your model to XMI and re-import it into a blank 0.9.x (or newer) ChronoSphere instance.");
            }
            ChronosVersion formatVersion = ChronosVersion.parse((String)formatVersionString);
            if (currentVersion.isSmallerThan(formatVersion)) {
                throw new ChronoSphereConfigurationException("This instance of ChronoSphere was created by ChronoSphere " + formatVersion + ", it cannot be opened by the current (older) version (" + currentVersion + ")!");
            }
            if (formatVersion.isSmallerThan(currentVersion)) {
                txGraph.variables().set("chronosphere.graphformat.version", (Object)currentVersion.toString());
                txGraph.tx().commit((Object)("ChronoSphere Graph Format version update from " + formatVersion + " to " + currentVersion));
            }
        }
    }
}

