/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.evolution;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.chronos.chronosphere.api.MetaModelEvolutionContext;
import org.chronos.chronosphere.api.MetaModelEvolutionController;
import org.chronos.chronosphere.api.MetaModelEvolutionIncubator;
import org.chronos.chronosphere.api.exceptions.ElementCannotBeEvolvedException;
import org.chronos.chronosphere.api.exceptions.MetaModelEvolutionCanceledException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class IncubatorBasedModelEvolutionController
implements MetaModelEvolutionController {
    protected final MetaModelEvolutionIncubator incubator;

    public IncubatorBasedModelEvolutionController(MetaModelEvolutionIncubator incubator) {
        Preconditions.checkNotNull((Object)incubator, (Object)"Precondition violation - argument 'incubator' must not be NULL!");
        this.incubator = incubator;
    }

    @Override
    public void migrate(MetaModelEvolutionContext context) throws MetaModelEvolutionCanceledException {
        Preconditions.checkNotNull((Object)context, (Object)"Precondition violation - argument 'context' must not be NULL!");
        this.executeClassEvolutionPhase(context);
        context.flush();
        this.executePropertyEvolutionPhase(context);
        context.flush();
        this.executeReferenceEvolutionPhase(context);
        context.flush();
    }

    protected void executeClassEvolutionPhase(MetaModelEvolutionContext context) {
        Iterator elementIterator = context.findInOldModel().startingFromAllEObjects().toIterator();
        while (elementIterator.hasNext()) {
            EObject oldObject = (EObject)elementIterator.next();
            try {
                EClass eClass = this.incubator.migrateClass(oldObject, context);
                if (eClass == null) continue;
                context.createAndAttachEvolvedEObject(oldObject, eClass);
            }
            catch (ElementCannotBeEvolvedException elementCannotBeEvolvedException) {}
        }
    }

    protected void executePropertyEvolutionPhase(MetaModelEvolutionContext context) {
        Iterator elementIterator = context.findInNewModel().startingFromAllEObjects().toIterator();
        while (elementIterator.hasNext()) {
            EObject newObject = (EObject)elementIterator.next();
            EObject oldObject = context.getCorrespondingEObjectInOldModel(newObject);
            try {
                this.incubator.updateAttributeValues(oldObject, newObject, context);
            }
            catch (ElementCannotBeEvolvedException e) {
                context.deleteInNewModel(newObject);
            }
        }
    }

    protected void executeReferenceEvolutionPhase(MetaModelEvolutionContext context) {
        Iterator elementIterator = context.findInNewModel().startingFromAllEObjects().toIterator();
        while (elementIterator.hasNext()) {
            EObject newObject = (EObject)elementIterator.next();
            EObject oldObject = context.getCorrespondingEObjectInOldModel(newObject);
            try {
                this.incubator.updateReferenceTargets(oldObject, newObject, context);
            }
            catch (ElementCannotBeEvolvedException e) {
                context.deleteInNewModel(newObject);
            }
        }
    }
}

