/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.evolution;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.chronos.chronosphere.api.ChronoSphere;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.api.MetaModelEvolutionController;
import org.chronos.chronosphere.api.MetaModelEvolutionIncubator;
import org.chronos.chronosphere.api.exceptions.MetaModelEvolutionCanceledException;
import org.chronos.chronosphere.impl.evolution.IncubatorBasedModelEvolutionController;
import org.chronos.chronosphere.impl.evolution.ModelEvolutionContextImpl;
import org.chronos.chronosphere.internal.api.ChronoSphereEPackageManagerInternal;
import org.eclipse.emf.ecore.EPackage;

public class MetaModelEvolutionProcess {
    public static boolean execute(ChronoSphere repository, String branch, MetaModelEvolutionIncubator incubator, Iterable<? extends EPackage> newEPackages) {
        Preconditions.checkNotNull((Object)repository, (Object)"Precondition violation - argument 'repository' must not be NULL!");
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkNotNull((Object)incubator, (Object)"Precondition violation - argument 'incubator' must not be NULL!");
        IncubatorBasedModelEvolutionController controller = new IncubatorBasedModelEvolutionController(incubator);
        return MetaModelEvolutionProcess.execute(repository, branch, controller, newEPackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(ChronoSphere repository, String branch, MetaModelEvolutionController controller, Iterable<? extends EPackage> newEPackages) {
        Preconditions.checkNotNull((Object)repository, (Object)"Precondition violation - argument 'repository' must not be NULL!");
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        Preconditions.checkNotNull((Object)controller, (Object)"Precondition violation - argument 'controller' must not be NULL!");
        ChronoSphereTransaction oldTx = repository.tx(branch);
        ChronoSphereTransaction newTx = repository.tx(branch);
        try {
            ModelEvolutionContextImpl context = new ModelEvolutionContextImpl(repository, branch, oldTx, newTx);
            ((ChronoSphereEPackageManagerInternal)repository.getEPackageManager()).overrideEPackages(newTx, newEPackages);
            newTx.commitIncremental();
            Iterator allEObjects = newTx.find().startingFromAllEObjects().toIterator();
            newTx.delete(allEObjects, false);
            newTx.commitIncremental();
            controller.migrate(context);
            newTx.commit();
            oldTx.rollback();
            boolean bl = true;
            return bl;
        }
        catch (MetaModelEvolutionCanceledException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (oldTx != null && oldTx.isOpen()) {
                oldTx.rollback();
            }
            if (newTx != null && newTx.isOpen()) {
                newTx.rollback();
            }
        }
    }
}

