/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.evolution;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.chronos.chronosphere.api.ChronoSphere;
import org.chronos.chronosphere.api.ChronoSphereTransaction;
import org.chronos.chronosphere.api.MetaModelEvolutionContext;
import org.chronos.chronosphere.api.SphereBranch;
import org.chronos.chronosphere.api.query.QueryStepBuilderStarter;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class ModelEvolutionContextImpl
implements MetaModelEvolutionContext {
    protected final ChronoSphere repository;
    protected final SphereBranch branch;
    protected final ChronoSphereTransactionInternal oldTx;
    protected final ChronoSphereTransactionInternal newTx;

    public ModelEvolutionContextImpl(ChronoSphere repository, String branch, ChronoSphereTransaction oldTx, ChronoSphereTransaction newTx) {
        Preconditions.checkNotNull((Object)repository, (Object)"Precondition violation - argument 'repository' must not be NULL!");
        Preconditions.checkNotNull((Object)oldTx, (Object)"Precondition violation - argument 'oldTx' must not be NULL!");
        Preconditions.checkNotNull((Object)newTx, (Object)"Precondition violation - argument 'newTx' must not be NULL!");
        Preconditions.checkNotNull((Object)branch, (Object)"Precondition violation - argument 'branch' must not be NULL!");
        this.repository = repository;
        this.branch = repository.getBranchManager().getBranch(branch);
        this.oldTx = (ChronoSphereTransactionInternal)oldTx;
        this.newTx = (ChronoSphereTransactionInternal)newTx;
    }

    @Override
    public EPackage getOldEPackage(String namespaceURI) {
        Preconditions.checkNotNull((Object)namespaceURI, (Object)"Precondition violation - argument 'namespaceURI' must not be NULL!");
        return this.oldTx.getEPackageByNsURI(namespaceURI);
    }

    @Override
    public EPackage getNewEPackage(String namespaceURI) {
        Preconditions.checkNotNull((Object)namespaceURI, (Object)"Precondition violation - argument 'namespaceURI' must not be NULL!");
        return this.newTx.getEPackageByNsURI(namespaceURI);
    }

    @Override
    public Set<EPackage> getOldEPackages() {
        return this.oldTx.getEPackages();
    }

    @Override
    public Set<EPackage> getNewEPackages() {
        return this.newTx.getEPackages();
    }

    @Override
    public SphereBranch getMigrationBranch() {
        return this.branch;
    }

    @Override
    public QueryStepBuilderStarter findInOldModel() {
        return this.oldTx.find();
    }

    @Override
    public QueryStepBuilderStarter findInNewModel() {
        return this.newTx.find();
    }

    @Override
    public void flush() {
        this.newTx.commitIncremental();
    }

    @Override
    public EObject createAndAttachEvolvedEObject(EObject oldObject, EClass newClass) {
        Preconditions.checkNotNull((Object)oldObject, (Object)"Precondition violation - argument 'oldObject' must not be NULL!");
        Preconditions.checkNotNull((Object)newClass, (Object)"Precondition violation - argument 'newClass' must not be NULL!");
        return this.newTx.createAndAttach(newClass, ((ChronoEObject)oldObject).getId());
    }

    @Override
    public EObject getCorrespondingEObjectInOldModel(EObject newEObject) {
        Preconditions.checkNotNull((Object)newEObject, (Object)"Precondition violation - argument 'newEObject' must not be NULL!");
        return this.oldTx.getEObjectById(((ChronoEObject)newEObject).getId());
    }

    @Override
    public EObject getCorrespondingEObjectInNewModel(EObject oldEObject) {
        Preconditions.checkNotNull((Object)oldEObject, (Object)"Precondition violation - argument 'oldEObject' must not be NULL!");
        return this.newTx.getEObjectById(((ChronoEObject)oldEObject).getId());
    }

    @Override
    public void deleteInNewModel(EObject newObject) {
        Preconditions.checkNotNull((Object)newObject, (Object)"Precondition violation - argument 'newObject' must not be NULL!");
        EObject obj = this.getCorrespondingEObjectInNewModel(newObject);
        if (obj != null) {
            this.newTx.delete(obj);
        }
    }
}

