/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.chronos.chronosphere.api.query.QueryStepBuilder;
import org.chronos.chronosphere.api.query.QueryStepBuilderInternal;
import org.chronos.chronosphere.api.query.UntypedQueryStepBuilder;
import org.chronos.chronosphere.impl.query.QueryUtils;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryAndStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryBackStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryDistinctStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryExceptNamedStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryExceptSetStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryFilterStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryFlatMapStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryLimitStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryMapStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryNamedStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryNotStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryOrStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryOrderByStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryUnionStepBuilder;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.impl.query.traversal.TraversalTransformer;

public abstract class AbstractQueryStepBuilder<S, I, E>
implements QueryStepBuilderInternal<S, E>,
TraversalTransformer<S, I, E> {
    protected TraversalChainElement previous;

    protected AbstractQueryStepBuilder(TraversalChainElement previous) {
        Preconditions.checkNotNull((Object)previous, (Object)"Precondition violation - argument 'previous' must not be NULL!");
        this.previous = previous;
    }

    @Override
    public QueryStepBuilder<S, E> filter(Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"Precondition violation - argument 'predicate' must not be NULL!");
        return new ObjectQueryFilterStepBuilder(this, predicate);
    }

    @Override
    public QueryStepBuilder<S, E> limit(long limit) {
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'limit' must not be negative!");
        return new ObjectQueryLimitStepBuilder(this, limit);
    }

    @Override
    public QueryStepBuilder<S, E> orderBy(Comparator<E> comparator) {
        Preconditions.checkNotNull(comparator, (Object)"Precondition violation - argument 'comparator' must not be NULL!");
        return new ObjectQueryOrderByStepBuilder(this, comparator);
    }

    @Override
    public QueryStepBuilder<S, E> distinct() {
        return new ObjectQueryDistinctStepBuilder(this);
    }

    @Override
    public <T> UntypedQueryStepBuilder<S, T> map(Function<E, T> function) {
        Preconditions.checkNotNull(function, (Object)"Precondition violation - argument 'function' must not be NULL!");
        return new ObjectQueryMapStepBuilder(this, function);
    }

    @Override
    public <T> UntypedQueryStepBuilder<S, T> flatMap(Function<E, Iterator<T>> function) {
        Preconditions.checkNotNull(function, (Object)"Precondition violation - argument 'function' must not be NULL!");
        return new ObjectQueryFlatMapStepBuilder(this, function);
    }

    @Override
    public QueryStepBuilder<S, E> notNull() {
        return this.filter(Objects::nonNull);
    }

    @Override
    public QueryStepBuilder<S, E> named(String stepName) {
        Preconditions.checkNotNull((Object)stepName, (Object)"Precondition violation - argument 'stepName' must not be NULL!");
        return new ObjectQueryNamedStepBuilder(this, stepName);
    }

    @Override
    public UntypedQueryStepBuilder<S, Object> back(String stepName) {
        Preconditions.checkNotNull((Object)stepName, (Object)"Precondition violation - argument 'stepName' must not be NULL!");
        return new ObjectQueryBackStepBuilder(this, stepName);
    }

    @Override
    public QueryStepBuilder<S, E> except(String stepName) {
        Preconditions.checkNotNull((Object)stepName, (Object)"Precondition violation - argument 'stepName' must not be NULL!");
        return new ObjectQueryExceptNamedStepBuilder(this, stepName);
    }

    @Override
    public QueryStepBuilder<S, E> except(Set<?> elementsToExclude) {
        Preconditions.checkNotNull(elementsToExclude, (Object)"Precondition violation - argument 'elementsToExclude' must not be NULL!");
        return new ObjectQueryExceptSetStepBuilder(this, elementsToExclude);
    }

    @Override
    public UntypedQueryStepBuilder<S, Object> union(QueryStepBuilder<E, ?> ... subqueries) {
        Preconditions.checkNotNull(subqueries, (Object)"Precondition violation - argument 'subqueries' must not be NULL!");
        Preconditions.checkArgument((subqueries.length > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'subqueries' must not be an empty array!");
        return new ObjectQueryUnionStepBuilder(this, subqueries);
    }

    @Override
    public QueryStepBuilder<S, E> and(QueryStepBuilder<E, ?> ... subqueries) {
        Preconditions.checkNotNull(subqueries, (Object)"Precondition violation - argument 'subqueries' must not be NULL!");
        Preconditions.checkArgument((subqueries.length > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'subqueries' must not be an empty array!");
        return new ObjectQueryAndStepBuilder(this, subqueries);
    }

    @Override
    public QueryStepBuilder<S, E> or(QueryStepBuilder<E, ?> ... subqueries) {
        Preconditions.checkNotNull(subqueries, (Object)"Precondition violation - argument 'subqueries' must not be NULL!");
        Preconditions.checkArgument((subqueries.length > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'subqueries' must not be an empty array!");
        return new ObjectQueryOrStepBuilder(this, subqueries);
    }

    @Override
    public QueryStepBuilder<S, E> not(QueryStepBuilder<E, ?> subquery) {
        Preconditions.checkNotNull(subquery, (Object)"Precondition violation - argument 'subquery' must not be NULL!");
        return new ObjectQueryNotStepBuilder(this, subquery);
    }

    @Override
    public Set<E> toSet() {
        return QueryUtils.prepareTerminalOperation(this, true).toSet();
    }

    @Override
    public List<E> toList() {
        return QueryUtils.prepareTerminalOperation(this, true).toList();
    }

    @Override
    public Stream<E> toStream() {
        return QueryUtils.prepareTerminalOperation(this, true).toStream();
    }

    @Override
    public long count() {
        return (Long)QueryUtils.prepareTerminalOperation(this, true).count().next();
    }

    @Override
    public Iterator<E> toIterator() {
        return QueryUtils.prepareTerminalOperation(this, true);
    }

    @Override
    public TraversalChainElement getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(TraversalChainElement previous) {
        Preconditions.checkNotNull((Object)previous, (Object)"Precondition violation - argument 'previous' must not be NULL!");
        this.previous = previous;
    }
}

