/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.chronos.chronosphere.api.query.Order;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EObjectAttributeComparator
implements Comparator<EObject> {
    private final EAttribute eAttribute;
    private final Order order;

    public EObjectAttributeComparator(EAttribute eAttribute, Order order) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        Preconditions.checkNotNull((Object)((Object)order), (Object)"Precondition violation - argument 'order' must not be NULL!");
        this.eAttribute = eAttribute;
        this.order = order;
    }

    @Override
    public int compare(EObject o1, EObject o2) {
        int comparison = this.compareInternal(o1, o2);
        if (this.order.equals((Object)Order.DESC)) {
            return comparison * -1;
        }
        return comparison;
    }

    protected int compareInternal(EObject o1, EObject o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        Object val1 = o1.eGet((EStructuralFeature)this.eAttribute);
        Object val2 = o2.eGet((EStructuralFeature)this.eAttribute);
        if (val1 == null && val2 == null) {
            return 0;
        }
        if (val1 != null && val2 == null) {
            return 1;
        }
        if (val1 == null && val2 != null) {
            return -1;
        }
        if (!(val1 instanceof Comparable)) {
            throw new IllegalStateException("Cannot execute comparison! Value '" + val1 + "' (class: '" + val1.getClass().getCanonicalName() + "') retrieved via EAttribute '" + this.eAttribute.getName() + "' is not Comparable!");
        }
        if (!(val2 instanceof Comparable)) {
            throw new IllegalStateException("Cannot execute comparison! Value '" + val2 + "' (class: '" + val2.getClass().getCanonicalName() + "') retrieved via EAttribute '" + this.eAttribute.getName() + "' is not Comparable!");
        }
        Comparable compVal1 = (Comparable)val1;
        Comparable compVal2 = (Comparable)val2;
        return compVal1.compareTo(compVal2);
    }
}

