/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.api.query.Direction;
import org.chronos.chronosphere.api.query.EObjectQueryStepBuilder;
import org.chronos.chronosphere.api.query.Order;
import org.chronos.chronosphere.api.query.QueryStepBuilder;
import org.chronos.chronosphere.api.query.QueryStepBuilderInternal;
import org.chronos.chronosphere.api.query.UntypedQueryStepBuilder;
import org.chronos.chronosphere.impl.query.EObjectAttributeComparator;
import org.chronos.chronosphere.impl.query.QueryUtils;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryAllReferencingEObjectsQueryStep;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryAndStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryAsEObjectStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryClosureStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryDistinctStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEAllContentsStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEContainerStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEContentsStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEGetInverseByNameStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEGetInverseByReferenceStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryEGetReferenceStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryExceptObjectsStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryHasFeatureValueStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryInstanceOfEClassNameStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryInstanceOfEClassStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryLimitStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryNonNullStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryNotStepBuilder;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryOrStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEGetAttributeStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEGetByNameStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEObjectBackStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEObjectReifyStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryEObjectUnionStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryExceptNamedStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryFilterStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryFlatMapStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryMapStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryNamedStepBuilder;
import org.chronos.chronosphere.impl.query.steps.object.ObjectQueryOrderByStepBuilder;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;
import org.chronos.chronosphere.impl.query.traversal.TraversalTransformer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class EObjectQueryStepBuilderImpl<S, I>
implements EObjectQueryStepBuilder<S>,
QueryStepBuilderInternal<S, EObject>,
TraversalTransformer<S, I, Vertex> {
    private TraversalChainElement previous;

    public EObjectQueryStepBuilderImpl(TraversalChainElement previous) {
        this.previous = previous;
    }

    @Override
    public EObjectQueryStepBuilder<S> orderBy(Comparator<EObject> comparator) {
        Preconditions.checkNotNull(comparator, (Object)"Precondition violation - argument 'comparator' must not be NULL!");
        ObjectQueryEObjectReifyStepBuilder reified = new ObjectQueryEObjectReifyStepBuilder(this);
        ObjectQueryOrderByStepBuilder ordered = new ObjectQueryOrderByStepBuilder(reified, comparator);
        return new EObjectQueryAsEObjectStepBuilder(ordered);
    }

    @Override
    public EObjectQueryStepBuilder<S> orderBy(EAttribute eAttribute, Order order) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        Preconditions.checkNotNull((Object)((Object)order), (Object)"Precondition violation - argument 'order' must not be NULL!");
        return this.orderBy((Comparator)new EObjectAttributeComparator(eAttribute, order));
    }

    @Override
    public EObjectQueryStepBuilder<S> distinct() {
        return new EObjectQueryDistinctStepBuilder(this);
    }

    @Override
    public <T> UntypedQueryStepBuilder<S, T> map(Function<EObject, T> function) {
        Preconditions.checkNotNull(function, (Object)"Precondition violation - argument 'function' must not be NULL!");
        ObjectQueryEObjectReifyStepBuilder reified = new ObjectQueryEObjectReifyStepBuilder(this);
        return new ObjectQueryMapStepBuilder(reified, function);
    }

    @Override
    public <T> UntypedQueryStepBuilder<S, T> flatMap(Function<EObject, Iterator<T>> function) {
        Preconditions.checkNotNull(function, (Object)"Precondition violation - argument 'function' must not be NULL!");
        ObjectQueryEObjectReifyStepBuilder reified = new ObjectQueryEObjectReifyStepBuilder(this);
        return new ObjectQueryFlatMapStepBuilder(reified, function);
    }

    @Override
    public Set<EObject> toSet() {
        QueryStepBuilderInternal<S, EObject> finalStep = this.reifyEObjects();
        GraphTraversal<S, EObject> traversal = QueryUtils.prepareTerminalOperation(finalStep, true);
        return traversal.toSet();
    }

    @Override
    public List<EObject> toList() {
        QueryStepBuilderInternal<S, EObject> finalStep = this.reifyEObjects();
        GraphTraversal<S, EObject> traversal = QueryUtils.prepareTerminalOperation(finalStep, true);
        return traversal.toList();
    }

    @Override
    public Iterator<EObject> toIterator() {
        QueryStepBuilderInternal<S, EObject> finalStep = this.reifyEObjects();
        GraphTraversal<S, EObject> traversal = QueryUtils.prepareTerminalOperation(finalStep, true);
        return traversal;
    }

    @Override
    public Stream<EObject> toStream() {
        QueryStepBuilderInternal<S, EObject> finalStep = this.reifyEObjects();
        GraphTraversal<S, EObject> traversal = QueryUtils.prepareTerminalOperation(finalStep, true);
        return traversal.toStream();
    }

    @Override
    public long count() {
        GraphTraversal traversal = QueryUtils.prepareTerminalOperation(this, false);
        return (Long)traversal.count().next();
    }

    @Override
    public EObjectQueryStepBuilder<S> limit(long limit) {
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"Precondition violation - argument 'limit' must not be negative!");
        return new EObjectQueryLimitStepBuilder(this, limit);
    }

    @Override
    public EObjectQueryStepBuilder<S> notNull() {
        return new EObjectQueryNonNullStepBuilder(this);
    }

    @Override
    public EObjectQueryStepBuilder<S> has(String eStructuralFeatureName, Object value) {
        Preconditions.checkNotNull((Object)eStructuralFeatureName, (Object)"Precondition violation - argument 'eStructuralFeatureName' must not be NULL!");
        ObjectQueryEObjectReifyStepBuilder reified = new ObjectQueryEObjectReifyStepBuilder(this);
        ObjectQueryFilterStepBuilder filtered = new ObjectQueryFilterStepBuilder(reified, eObject -> {
            if (eObject == null) {
                return false;
            }
            EClass eClass = eObject.eClass();
            EStructuralFeature feature = eClass.getEStructuralFeature(eStructuralFeatureName);
            if (feature == null) {
                return false;
            }
            return Objects.equal((Object)eObject.eGet(feature), (Object)value);
        });
        return new EObjectQueryAsEObjectStepBuilder(filtered);
    }

    @Override
    public EObjectQueryStepBuilder<S> has(EStructuralFeature eStructuralFeature, Object value) {
        Preconditions.checkNotNull((Object)eStructuralFeature, (Object)"Precondition violation - argument 'eStructuralFeature' must not be NULL!");
        return new EObjectQueryHasFeatureValueStepBuilder(this, eStructuralFeature, value);
    }

    @Override
    public EObjectQueryStepBuilder<S> isInstanceOf(EClass eClass) {
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        return this.isInstanceOf(eClass, true);
    }

    @Override
    public EObjectQueryStepBuilder<S> isInstanceOf(EClass eClass, boolean allowSubclasses) {
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        return new EObjectQueryInstanceOfEClassStepBuilder(this, eClass, allowSubclasses);
    }

    @Override
    public EObjectQueryStepBuilder<S> isInstanceOf(String eClassName) {
        Preconditions.checkNotNull((Object)eClassName, (Object)"Precondition violation - argument 'eClassName' must not be NULL!");
        return this.isInstanceOf(eClassName, true);
    }

    @Override
    public EObjectQueryStepBuilder<S> isInstanceOf(String eClassName, boolean allowSubclasses) {
        Preconditions.checkNotNull((Object)eClassName, (Object)"Precondition violation - argument 'eClassName' must not be NULL!");
        return new EObjectQueryInstanceOfEClassNameStepBuilder(this, eClassName, allowSubclasses);
    }

    @Override
    public UntypedQueryStepBuilder<S, Object> eGet(String eStructuralFeatureName) {
        Preconditions.checkNotNull((Object)eStructuralFeatureName, (Object)"Precondition violation - argument 'eStructuralFeatureName' must not be NULL!");
        return new ObjectQueryEGetByNameStepBuilder(this, eStructuralFeatureName);
    }

    @Override
    public EObjectQueryStepBuilder<S> eGet(EReference eReference) {
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        return new EObjectQueryEGetReferenceStepBuilder(this, eReference);
    }

    @Override
    public EObjectQueryStepBuilder<S> eGetInverse(EReference eReference) {
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        return new EObjectQueryEGetInverseByReferenceStepBuilder(this, eReference);
    }

    @Override
    public EObjectQueryStepBuilder<S> eGetInverse(String referenceName) {
        Preconditions.checkNotNull((Object)referenceName, (Object)"Precondition violation - argument 'referenceName' must not be NULL!");
        return new EObjectQueryEGetInverseByNameStepBuilder(this, referenceName);
    }

    @Override
    public UntypedQueryStepBuilder<S, Object> eGet(EAttribute eAttribute) {
        Preconditions.checkNotNull((Object)eAttribute, (Object)"Precondition violation - argument 'eAttribute' must not be NULL!");
        return new ObjectQueryEGetAttributeStepBuilder(this, eAttribute);
    }

    @Override
    public EObjectQueryStepBuilder<S> eContainer() {
        return new EObjectQueryEContainerStepBuilder(this);
    }

    @Override
    public EObjectQueryStepBuilder<S> eContents() {
        return new EObjectQueryEContentsStepBuilder(this);
    }

    @Override
    public EObjectQueryStepBuilder<S> eAllContents() {
        return new EObjectQueryEAllContentsStepBuilder(this);
    }

    @Override
    public EObjectQueryStepBuilder<S> allReferencingEObjects() {
        return new EObjectQueryAllReferencingEObjectsQueryStep(this);
    }

    @Override
    public EObjectQueryStepBuilder<S> named(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Precondition violation - argument 'name' must not be NULL!");
        ObjectQueryEObjectReifyStepBuilder reified = new ObjectQueryEObjectReifyStepBuilder(this);
        ObjectQueryNamedStepBuilder except = new ObjectQueryNamedStepBuilder(reified, name);
        return new EObjectQueryAsEObjectStepBuilder(except);
    }

    @Override
    public UntypedQueryStepBuilder<S, Object> back(String stepName) {
        Preconditions.checkNotNull((Object)stepName, (Object)"Precondition violation - argument 'stepName' must not be NULL!");
        return new ObjectQueryEObjectBackStepBuilder(this, stepName);
    }

    public EObjectQueryStepBuilder<S> except(String stepName) {
        Preconditions.checkNotNull((Object)stepName, (Object)"Precondition violation - argument 'stepName' must not be NULL!");
        ObjectQueryEObjectReifyStepBuilder reified = new ObjectQueryEObjectReifyStepBuilder(this);
        ObjectQueryExceptNamedStepBuilder except = new ObjectQueryExceptNamedStepBuilder(reified, stepName);
        return new EObjectQueryAsEObjectStepBuilder(except);
    }

    public EObjectQueryStepBuilder<S> except(Set<?> elementsToExclude) {
        Preconditions.checkNotNull(elementsToExclude, (Object)"Precondition violation - argument 'elementsToExclude' must not be NULL!");
        return new EObjectQueryExceptObjectsStepBuilder(this, elementsToExclude);
    }

    @Override
    public UntypedQueryStepBuilder<S, Object> union(QueryStepBuilder<EObject, ?> ... subqueries) {
        Preconditions.checkNotNull(subqueries, (Object)"Precondition violation - argument 'subqueries' must not be NULL!");
        Preconditions.checkArgument((subqueries.length > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'subqueries' must not be an empty array!");
        return new ObjectQueryEObjectUnionStepBuilder(this, subqueries);
    }

    public EObjectQueryStepBuilder<S> and(QueryStepBuilder<EObject, ?> ... subqueries) {
        Preconditions.checkNotNull(subqueries, (Object)"Precondition violation - argument 'subqueries' must not be NULL!");
        Preconditions.checkArgument((subqueries.length > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'subqueries' must not be an empty array!");
        return new EObjectQueryAndStepBuilder(this, subqueries);
    }

    public EObjectQueryStepBuilder<S> or(QueryStepBuilder<EObject, ?> ... subqueries) {
        Preconditions.checkNotNull(subqueries, (Object)"Precondition violation - argument 'subqueries' must not be NULL!");
        Preconditions.checkArgument((subqueries.length > 0 ? 1 : 0) != 0, (Object)"Precondition violation - argument 'subqueries' must not be an empty array!");
        return new EObjectQueryOrStepBuilder(this, subqueries);
    }

    public EObjectQueryStepBuilder<S> not(QueryStepBuilder<EObject, ?> subquery) {
        Preconditions.checkNotNull(subquery, (Object)"Precondition violation - argument 'subquery' must not be NULL!");
        return new EObjectQueryNotStepBuilder(this, subquery);
    }

    @Override
    public EObjectQueryStepBuilder<S> filter(Predicate<EObject> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"Precondition violation - argument 'predicate' must not be NULL!");
        ObjectQueryEObjectReifyStepBuilder reified = new ObjectQueryEObjectReifyStepBuilder(this);
        ObjectQueryFilterStepBuilder filtered = new ObjectQueryFilterStepBuilder(reified, predicate);
        return new EObjectQueryAsEObjectStepBuilder(filtered);
    }

    @Override
    public EObjectQueryStepBuilder<S> closure(EReference eReference, Direction direction) {
        Preconditions.checkNotNull((Object)eReference, (Object)"Precondition violation - argument 'eReference' must not be NULL!");
        Preconditions.checkNotNull((Object)((Object)direction), (Object)"Precondition violation - argument 'direction' must not be NULL!");
        return new EObjectQueryClosureStepBuilder(this, eReference, direction);
    }

    @Override
    public TraversalChainElement getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(TraversalChainElement previous) {
        Preconditions.checkNotNull((Object)previous, (Object)"Precondition violation - argument 'previous' must not be NULL!");
        this.previous = previous;
    }

    protected QueryStepBuilderInternal<S, EObject> reifyEObjects() {
        return new ObjectQueryEObjectReifyStepBuilder(this);
    }
}

