/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query;

import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.chronos.chronosphere.api.query.NumericQueryStepBuilder;
import org.chronos.chronosphere.impl.query.AbstractQueryStepBuilder;
import org.chronos.chronosphere.impl.query.QueryUtils;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsByteStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsDoubleStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsFloatStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsIntegerStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsLongStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryAsShortStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryCeilStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryFloorStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryRoundStepBuilder;
import org.chronos.chronosphere.impl.query.steps.numeric.NumericQueryRoundToIntStepBuilder;
import org.chronos.chronosphere.impl.query.traversal.TraversalChainElement;

public abstract class NumericQueryStepBuilderImpl<S, I, E extends Number>
extends AbstractQueryStepBuilder<S, I, E>
implements NumericQueryStepBuilder<S, E> {
    public NumericQueryStepBuilderImpl(TraversalChainElement previous) {
        super(previous);
    }

    @Override
    public Optional<Double> sumAsDouble() {
        GraphTraversal iterator = QueryUtils.prepareTerminalOperation(this, true);
        Double sum = null;
        while (iterator.hasNext()) {
            Number next = (Number)iterator.next();
            if (next == null) continue;
            if (sum != null) {
                sum = sum + next.doubleValue();
                continue;
            }
            sum = next.doubleValue();
        }
        return Optional.ofNullable(sum);
    }

    @Override
    public Optional<Long> sumAsLong() {
        GraphTraversal iterator = QueryUtils.prepareTerminalOperation(this, true);
        Long sum = null;
        while (iterator.hasNext()) {
            Number next = (Number)iterator.next();
            if (next == null) continue;
            if (sum != null) {
                sum = sum + next.longValue();
                continue;
            }
            sum = next.longValue();
        }
        return Optional.ofNullable(sum);
    }

    @Override
    public Optional<Double> average() {
        GraphTraversal iterator = QueryUtils.prepareTerminalOperation(this, true);
        Double sum = null;
        long count = 0L;
        while (iterator.hasNext()) {
            ++count;
            Number next = (Number)iterator.next();
            if (next == null) continue;
            if (sum != null) {
                sum = sum + next.doubleValue();
                continue;
            }
            sum = next.doubleValue();
        }
        if (count == 0L) {
            return Optional.empty();
        }
        return Optional.of(sum / (double)count);
    }

    @Override
    public Optional<Double> maxAsDouble() {
        GraphTraversal iterator = QueryUtils.prepareTerminalOperation(this, true);
        Double max = null;
        while (iterator.hasNext()) {
            Number element = (Number)iterator.next();
            if (element == null || max != null && !(element.doubleValue() > max)) continue;
            max = element.doubleValue();
        }
        return Optional.ofNullable(max);
    }

    @Override
    public Optional<Long> maxAsLong() {
        GraphTraversal iterator = QueryUtils.prepareTerminalOperation(this, true);
        Long max = null;
        while (iterator.hasNext()) {
            Number element = (Number)iterator.next();
            if (element == null || max != null && element.longValue() <= max) continue;
            max = element.longValue();
        }
        return Optional.ofNullable(max);
    }

    @Override
    public Optional<Double> minAsDouble() {
        GraphTraversal iterator = QueryUtils.prepareTerminalOperation(this, true);
        Double min = null;
        while (iterator.hasNext()) {
            Number element = (Number)iterator.next();
            if (element == null || min != null && !(element.doubleValue() < min)) continue;
            min = element.doubleValue();
        }
        return Optional.ofNullable(min);
    }

    @Override
    public Optional<Long> minAsLong() {
        GraphTraversal iterator = QueryUtils.prepareTerminalOperation(this, true);
        Long min = null;
        while (iterator.hasNext()) {
            Number element = (Number)iterator.next();
            if (element == null || min != null && element.longValue() >= min) continue;
            min = element.longValue();
        }
        return Optional.ofNullable(min);
    }

    @Override
    public NumericQueryStepBuilder<S, Long> round() {
        return new NumericQueryRoundStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Integer> roundToInt() {
        return new NumericQueryRoundToIntStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Long> floor() {
        return new NumericQueryFloorStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Long> ceil() {
        return new NumericQueryCeilStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Byte> asByte() {
        return new NumericQueryAsByteStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Short> asShort() {
        return new NumericQueryAsShortStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Integer> asInteger() {
        return new NumericQueryAsIntegerStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Long> asLong() {
        return new NumericQueryAsLongStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Float> asFloat() {
        return new NumericQueryAsFloatStepBuilder(this);
    }

    @Override
    public NumericQueryStepBuilder<S, Double> asDouble() {
        return new NumericQueryAsDoubleStepBuilder(this);
    }
}

