/*
 * Decompiled with CFR 0.152.
 */
package org.chronos.chronosphere.impl.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.chronos.chronosphere.api.query.EObjectQueryStepBuilder;
import org.chronos.chronosphere.api.query.QueryStepBuilderStarter;
import org.chronos.chronosphere.emf.api.ChronoEObject;
import org.chronos.chronosphere.emf.internal.api.ChronoEObjectInternal;
import org.chronos.chronosphere.impl.query.steps.eobject.EObjectQueryIdentityStepBuilder;
import org.chronos.chronosphere.impl.query.traversal.TraversalBaseSource;
import org.chronos.chronosphere.internal.api.ChronoSphereTransactionInternal;
import org.chronos.chronosphere.internal.ogm.api.ChronoEPackageRegistry;
import org.chronos.chronosphere.internal.ogm.api.ChronoSphereGraphFormat;
import org.chronos.chronosphere.internal.ogm.api.VertexKind;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class QueryStepBuilderStarterImpl
implements QueryStepBuilderStarter {
    private ChronoSphereTransactionInternal owningTransaction;

    public QueryStepBuilderStarterImpl(ChronoSphereTransactionInternal owningTransaction) {
        Preconditions.checkNotNull((Object)owningTransaction, (Object)"Precondition violation - argument 'owningTransaction' must not be NULL!");
        this.owningTransaction = owningTransaction;
    }

    @Override
    public EObjectQueryStepBuilder<EObject> startingFromAllEObjects() {
        TraversalBaseSource<Vertex, Vertex> source = new TraversalBaseSource<Vertex, Vertex>(this.owningTransaction, g -> g.traversal().V(new Object[0]).has("kind", (Object)VertexKind.EOBJECT.toString()));
        return this.createEQueryStepBuilderFromTraversalSource(source);
    }

    @Override
    public EObjectQueryStepBuilder<EObject> startingFromInstancesOf(EClass eClass) {
        Preconditions.checkNotNull((Object)eClass, (Object)"Precondition violation - argument 'eClass' must not be NULL!");
        String id = this.owningTransaction.getEPackageRegistry().getEClassID(eClass);
        TraversalBaseSource<Vertex, Vertex> source = new TraversalBaseSource<Vertex, Vertex>(this.owningTransaction, g -> g.traversal().V(new Object[0]).has("eClass", (Object)id).has("kind", (Object)VertexKind.EOBJECT.toString()));
        return this.createEQueryStepBuilderFromTraversalSource(source);
    }

    @Override
    public EObjectQueryStepBuilder<EObject> startingFromInstancesOf(String eClassName) {
        Preconditions.checkNotNull((Object)eClassName, (Object)"Precondition violation - argument 'eClassName' must not be NULL!");
        EClass eClass = this.owningTransaction.getEClassByQualifiedName(eClassName);
        if (eClass == null) {
            eClass = this.owningTransaction.getEClassBySimpleName(eClassName);
        }
        return this.startingFromInstancesOf(eClass);
    }

    @Override
    public EObjectQueryStepBuilder<EObject> startingFromEObjectsWith(EAttribute attribute, Object value) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Precondition violation - argument 'attribute' must not be NULL!");
        ChronoEPackageRegistry registry = this.owningTransaction.getEPackageRegistry();
        String vertexPropertyKey = ChronoSphereGraphFormat.createVertexPropertyKey(registry, attribute);
        TraversalBaseSource<Vertex, Vertex> source = new TraversalBaseSource<Vertex, Vertex>(this.owningTransaction, g -> g.traversal().V(new Object[0]).has("kind", (Object)VertexKind.EOBJECT.toString()).has(vertexPropertyKey, value));
        return this.createEQueryStepBuilderFromTraversalSource(source);
    }

    @Override
    public EObjectQueryStepBuilder<EObject> startingFromEObject(EObject eObject) {
        Preconditions.checkNotNull((Object)eObject, (Object)"Precondition violation - argument 'eObject' must not be NULL!");
        ChronoEObjectInternal chronoEObject = (ChronoEObjectInternal)eObject;
        if (!chronoEObject.isAttached()) {
            throw new IllegalArgumentException("The given EObject is not attached to the repository - cannot start a query from it!");
        }
        TraversalBaseSource<Vertex, Vertex> source = new TraversalBaseSource<Vertex, Vertex>(this.owningTransaction, g -> g.traversal().V(new Object[]{chronoEObject.getId()}));
        return this.createEQueryStepBuilderFromTraversalSource(source);
    }

    @Override
    public EObjectQueryStepBuilder<EObject> startingFromEObjects(Iterable<? extends EObject> eObjects) {
        Preconditions.checkNotNull(eObjects, (Object)"Precondition violation - argument 'eObjects' must not be NULL!");
        Iterable filteredEObjects = Iterables.filter(eObjects, eObject -> {
            ChronoEObjectInternal chronoEObject = (ChronoEObjectInternal)eObject;
            if (!chronoEObject.isAttached()) {
                throw new IllegalArgumentException("One of the given EObjects is not attached to the repository - cannot start a query from them!");
            }
            return chronoEObject.exists();
        });
        ArrayList ids = Lists.newArrayList();
        filteredEObjects.forEach(eObject -> ids.add(((ChronoEObject)eObject).getId()));
        String[] idsArray = ids.toArray(new String[ids.size()]);
        TraversalBaseSource<Object, Object> source = ids.isEmpty() ? new TraversalBaseSource<Vertex, Vertex>(this.owningTransaction, g -> g.traversal().V(new Object[]{UUID.randomUUID()})) : new TraversalBaseSource(this.owningTransaction, g -> g.traversal().V((Object[])idsArray));
        return this.createEQueryStepBuilderFromTraversalSource(source);
    }

    @Override
    public EObjectQueryStepBuilder<EObject> startingFromEObjects(Iterator<? extends EObject> eObjects) {
        Preconditions.checkNotNull(eObjects, (Object)"Precondition violation - argument 'eObjects' must not be NULL!");
        ArrayList list = Lists.newArrayList(eObjects);
        return this.startingFromEObjects(list);
    }

    private EObjectQueryStepBuilder<EObject> createEQueryStepBuilderFromTraversalSource(TraversalBaseSource<Vertex, Vertex> source) {
        return new EObjectQueryIdentityStepBuilder<EObject>(source);
    }
}

